/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.slotmanager.AnyMatchingSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingTaskManagerSlotInformation;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AnyMatchingSlotMatchingStrategyTest {
    private final InstanceID instanceId = new InstanceID();
    private TestingTaskManagerSlotInformation largeTaskManagerSlotInformation = null;
    private Collection<TestingTaskManagerSlotInformation> freeSlots = null;

    AnyMatchingSlotMatchingStrategyTest() {
    }

    @BeforeEach
    void setup() {
        ResourceProfile largeResourceProfile = ResourceProfile.fromResources((double)10.2, (int)42);
        ResourceProfile smallResourceProfile = ResourceProfile.fromResources((double)1.0, (int)1);
        this.largeTaskManagerSlotInformation = TestingTaskManagerSlotInformation.newBuilder().setInstanceId(this.instanceId).setResourceProfile(largeResourceProfile).build();
        this.freeSlots = Arrays.asList(TestingTaskManagerSlotInformation.newBuilder().setInstanceId(this.instanceId).setResourceProfile(smallResourceProfile).build(), this.largeTaskManagerSlotInformation);
    }

    @Test
    void findMatchingSlot_withFulfillableRequest_returnsFulfillingSlot() {
        Optional optionalMatchingSlot = AnyMatchingSlotMatchingStrategy.INSTANCE.findMatchingSlot(this.largeTaskManagerSlotInformation.getResourceProfile(), this.freeSlots, this.countSlotsPerInstance(this.freeSlots));
        Assertions.assertThat((Optional)optionalMatchingSlot).hasValueSatisfying(slot -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)slot.getSlotId()).isEqualTo((Object)this.largeTaskManagerSlotInformation.getSlotId());
        });
    }

    @Test
    void findMatchingSlot_withUnfulfillableRequest_returnsEmptyResult() {
        Optional optionalMatchingSlot = AnyMatchingSlotMatchingStrategy.INSTANCE.findMatchingSlot(ResourceProfile.fromResources((double)Double.MAX_VALUE, (int)Integer.MAX_VALUE), this.freeSlots, this.countSlotsPerInstance(this.freeSlots));
        Assertions.assertThat((Optional)optionalMatchingSlot).isNotPresent();
    }

    private Function<InstanceID, Integer> countSlotsPerInstance(Collection<? extends TestingTaskManagerSlotInformation> freeSlots) {
        return currentInstanceId -> (int)freeSlots.stream().filter(slot -> slot.getInstanceId().equals(currentInstanceId)).count();
    }
}

