/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestHandler;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.TestingOperatorCoordinator;

public class TestingCoordinationRequestHandler
extends TestingOperatorCoordinator
implements CoordinationRequestHandler {
    public TestingCoordinationRequestHandler(OperatorCoordinator.Context context) {
        super(context);
    }

    public CompletableFuture<CoordinationResponse> handleCoordinationRequest(CoordinationRequest request) {
        Request req = (Request)request;
        return CompletableFuture.completedFuture(new Response(req.getPayload()));
    }

    public static class Response<T>
    implements CoordinationResponse {
        private static final long serialVersionUID = 1L;
        private final T payload;

        public Response(T payload) {
            this.payload = payload;
        }

        public T getPayload() {
            return this.payload;
        }
    }

    public static class Request<T>
    implements CoordinationRequest {
        private static final long serialVersionUID = 1L;
        private final T payload;

        public Request(T payload) {
            this.payload = payload;
        }

        public T getPayload() {
            return this.payload;
        }
    }

    public static final class Provider
    implements OperatorCoordinator.Provider {
        private static final long serialVersionUID = 1L;
        private final OperatorID operatorId;

        public Provider(OperatorID operatorId) {
            this.operatorId = operatorId;
        }

        public OperatorID getOperatorId() {
            return this.operatorId;
        }

        public OperatorCoordinator create(OperatorCoordinator.Context context) {
            return new TestingCoordinationRequestHandler(context);
        }
    }
}

