/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.SupplierWithException;

public class TestingRetrievalBase {
    private final BlockingQueue<LeaderInformation> leaderEventQueue = new LinkedBlockingQueue<LeaderInformation>();
    private final BlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue<Throwable>();
    private LeaderInformation leader = LeaderInformation.empty();
    private String oldAddress;
    private Throwable error;

    public String waitForNewLeader() throws Exception {
        this.throwExceptionIfNotNull();
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            this.leader = this.leaderEventQueue.take();
            return !this.leader.isEmpty() && !this.leader.getLeaderAddress().equals(this.oldAddress);
        }));
        this.oldAddress = this.leader.getLeaderAddress();
        return this.leader.getLeaderAddress();
    }

    public void waitForEmptyLeaderInformation() throws Exception {
        this.throwExceptionIfNotNull();
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            this.leader = this.leaderEventQueue.take();
            return this.leader.isEmpty();
        }));
        this.oldAddress = null;
    }

    public void waitForError() throws Exception {
        this.error = this.errorQueue.take();
    }

    public void handleError(Throwable ex) {
        this.errorQueue.offer(ex);
    }

    public LeaderInformation getLeader() {
        return this.leader;
    }

    public String getAddress() {
        return this.leader.getLeaderAddress();
    }

    public UUID getLeaderSessionID() {
        return this.leader.getLeaderSessionID();
    }

    public void offerToLeaderQueue(LeaderInformation leaderInformation) {
        this.leaderEventQueue.offer(leaderInformation);
    }

    public int getLeaderEventQueueSize() {
        return this.leaderEventQueue.size();
    }

    @Nullable
    public Throwable getError() {
        return this.error == null ? (Throwable)this.errorQueue.poll() : this.error;
    }

    private void throwExceptionIfNotNull() throws Exception {
        if (this.error != null) {
            ExceptionUtils.rethrowException((Throwable)this.error);
        }
    }
}

