/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultDeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.RequestSlotMatchingStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SimpleRequestSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class DeclarativeSlotPoolBridgeBuilder {
    private JobID jobId = new JobID();
    private Time batchSlotTimeout = Time.milliseconds((long)((Long)JobManagerOptions.SLOT_IDLE_TIMEOUT.defaultValue()));
    private Time idleSlotTimeout = TestingUtils.infiniteTime();
    private Clock clock = SystemClock.getInstance();
    @Nullable
    private ResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway();
    private RequestSlotMatchingStrategy requestSlotMatchingStrategy = SimpleRequestSlotMatchingStrategy.INSTANCE;

    public DeclarativeSlotPoolBridgeBuilder setResourceManagerGateway(@Nullable ResourceManagerGateway resourceManagerGateway) {
        this.resourceManagerGateway = resourceManagerGateway;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setBatchSlotTimeout(Time batchSlotTimeout) {
        this.batchSlotTimeout = batchSlotTimeout;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setIdleSlotTimeout(Time idleSlotTimeout) {
        this.idleSlotTimeout = idleSlotTimeout;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setJobId(JobID jobId) {
        this.jobId = jobId;
        return this;
    }

    public DeclarativeSlotPoolBridgeBuilder setRequestSlotMatchingStrategy(RequestSlotMatchingStrategy requestSlotMatchingStrategy) {
        this.requestSlotMatchingStrategy = requestSlotMatchingStrategy;
        return this;
    }

    public DeclarativeSlotPoolBridge build() {
        return new DeclarativeSlotPoolBridge(this.jobId, (DeclarativeSlotPoolFactory)new DefaultDeclarativeSlotPoolFactory(), this.clock, TestingUtils.infiniteTime(), this.idleSlotTimeout, this.batchSlotTimeout, this.requestSlotMatchingStrategy);
    }

    public DeclarativeSlotPoolBridge buildAndStart(ComponentMainThreadExecutor componentMainThreadExecutor) throws Exception {
        DeclarativeSlotPoolBridge slotPool = this.build();
        slotPool.start(JobMasterId.generate(), "foobar", componentMainThreadExecutor);
        if (this.resourceManagerGateway != null) {
            CompletableFuture.runAsync(() -> slotPool.connectToResourceManager(this.resourceManagerGateway), (Executor)componentMainThreadExecutor).join();
        }
        return slotPool;
    }
}

