/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.AvailabilityNotifier;

public class TestingAvailabilityNotifier
implements AvailabilityNotifier {
    private final BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<Void>> notifyFunction;

    public TestingAvailabilityNotifier(BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<Void>> notifyFunction) {
        this.notifyFunction = notifyFunction;
    }

    public void notifyAvailable(TieredStoragePartitionId partitionId, TieredStorageSubpartitionId subpartitionId) {
        this.notifyFunction.apply(partitionId, subpartitionId).complete(null);
    }

    public static class Builder {
        private BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<Void>> notifyFunction = (partitionId, subpartitionId) -> new CompletableFuture();

        public Builder setNotifyFunction(BiFunction<TieredStoragePartitionId, TieredStorageSubpartitionId, CompletableFuture<Void>> notifyFunction) {
            this.notifyFunction = notifyFunction;
            return this;
        }

        public TestingAvailabilityNotifier build() {
            return new TestingAvailabilityNotifier(this.notifyFunction);
        }
    }
}

