/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.file;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingPartitionFileWriter
implements PartitionFileWriter {
    private final BiFunction<TieredStoragePartitionId, List<PartitionFileWriter.SubpartitionBufferContext>, CompletableFuture<Void>> writeFunction;
    private final Runnable releaseRunnable;

    private TestingPartitionFileWriter(BiFunction<TieredStoragePartitionId, List<PartitionFileWriter.SubpartitionBufferContext>, CompletableFuture<Void>> writeFunction, Runnable releaseRunnable) {
        this.writeFunction = writeFunction;
        this.releaseRunnable = releaseRunnable;
    }

    public CompletableFuture<Void> write(TieredStoragePartitionId partitionId, List<PartitionFileWriter.SubpartitionBufferContext> buffersToWrite) {
        return this.writeFunction.apply(partitionId, buffersToWrite);
    }

    public void release() {
        this.releaseRunnable.run();
    }

    public static class Builder {
        private BiFunction<TieredStoragePartitionId, List<PartitionFileWriter.SubpartitionBufferContext>, CompletableFuture<Void>> writeFunction = (partitionId, subpartitionBufferContexts) -> FutureUtils.completedVoidFuture();
        private Runnable releaseRunnable = () -> {};

        public Builder setWriteFunction(BiFunction<TieredStoragePartitionId, List<PartitionFileWriter.SubpartitionBufferContext>, CompletableFuture<Void>> writeFunction) {
            this.writeFunction = writeFunction;
            return this;
        }

        public Builder setReleaseRunnable(Runnable releaseRunnable) {
            this.releaseRunnable = releaseRunnable;
            return this;
        }

        public TestingPartitionFileWriter build() {
            return new TestingPartitionFileWriter(this.writeFunction, this.releaseRunnable);
        }
    }
}

