/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered;

import java.util.function.BiFunction;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;

public class TestingTierProducerAgent
implements TierProducerAgent {
    private final BiFunction<TieredStorageSubpartitionId, Integer, Boolean> tryStartNewSegmentSupplier;
    private final BiFunction<TieredStorageSubpartitionId, Buffer, Boolean> tryWriterFunction;
    private final Runnable closeRunnable;

    private TestingTierProducerAgent(BiFunction<TieredStorageSubpartitionId, Integer, Boolean> tryStartNewSegmentSupplier, BiFunction<TieredStorageSubpartitionId, Buffer, Boolean> tryWriterFunction, Runnable closeRunnable) {
        this.tryStartNewSegmentSupplier = tryStartNewSegmentSupplier;
        this.tryWriterFunction = tryWriterFunction;
        this.closeRunnable = closeRunnable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean tryStartNewSegment(TieredStorageSubpartitionId subpartitionId, int segmentId) {
        return this.tryStartNewSegmentSupplier.apply(subpartitionId, segmentId);
    }

    public boolean tryWrite(TieredStorageSubpartitionId subpartitionId, Buffer finishedBuffer, Object bufferOwner) {
        return this.tryWriterFunction.apply(subpartitionId, finishedBuffer);
    }

    public void close() {
        this.closeRunnable.run();
    }

    public static class Builder {
        private BiFunction<TieredStorageSubpartitionId, Integer, Boolean> tryStartSegmentSupplier = (subpartitionId, integer) -> true;
        private BiFunction<TieredStorageSubpartitionId, Buffer, Boolean> tryWriterFunction = (subpartitionId, buffer) -> true;
        private Runnable closeRunnable = () -> {};

        public Builder setTryStartSegmentSupplier(BiFunction<TieredStorageSubpartitionId, Integer, Boolean> tryStartSegmentSupplier) {
            this.tryStartSegmentSupplier = tryStartSegmentSupplier;
            return this;
        }

        public Builder setTryWriterFunction(BiFunction<TieredStorageSubpartitionId, Buffer, Boolean> tryWriterFunction) {
            this.tryWriterFunction = tryWriterFunction;
            return this;
        }

        public Builder setCloseRunnable(Runnable closeRunnable) {
            this.closeRunnable = closeRunnable;
            return this;
        }

        public TestingTierProducerAgent build() {
            return new TestingTierProducerAgent(this.tryStartSegmentSupplier, this.tryWriterFunction, this.closeRunnable);
        }
    }
}

