/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Optional;
import java.util.concurrent.Executors;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.FileChannelManagerImpl;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingResultPartition;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartition;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.PipelinedResultPartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.SortMergeResultPartition;
import org.apache.flink.runtime.io.network.partition.hybrid.HsResultPartition;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageConfiguration;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.netty.TieredStorageNettyServiceImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.TieredResultPartition;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.shuffle.TieredResultPartitionFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.shuffle.PartitionDescriptorBuilder;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.NettyShuffleDescriptorBuilder;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
class ResultPartitionFactoryTest {
    private static final String tempDir = EnvironmentInformation.getTemporaryFileDirectory();
    private static final int SEGMENT_SIZE = 64;
    private static FileChannelManager fileChannelManager;

    ResultPartitionFactoryTest() {
    }

    @BeforeAll
    static void setUp() {
        fileChannelManager = new FileChannelManagerImpl(new String[]{tempDir}, "testing");
    }

    @AfterAll
    static void shutdown() throws Exception {
        fileChannelManager.close();
    }

    @Test
    void testBoundedBlockingSubpartitionsCreated() {
        BoundedBlockingResultPartition resultPartition = (BoundedBlockingResultPartition)ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING);
        Assertions.assertThat((Object[])resultPartition.subpartitions).allSatisfy(sp -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)sp).isInstanceOf(BoundedBlockingSubpartition.class);
        });
    }

    @Test
    void testPipelinedSubpartitionsCreated() {
        PipelinedResultPartition resultPartition = (PipelinedResultPartition)ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.PIPELINED);
        Assertions.assertThat((Object[])resultPartition.subpartitions).allSatisfy(sp -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)sp).isInstanceOf(PipelinedSubpartition.class);
        });
    }

    @Test
    void testSortMergePartitionCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING, 1);
        Assertions.assertThat((Object)resultPartition).isInstanceOf(SortMergeResultPartition.class);
    }

    @Test
    void testHybridFullResultPartitionOfLegacyModeCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_FULL);
        Assertions.assertThat((Object)resultPartition).isInstanceOf(HsResultPartition.class);
    }

    @Test
    void testHybridSelectiveResultPartitionOfLegacyModeCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_SELECTIVE);
        Assertions.assertThat((Object)resultPartition).isInstanceOf(HsResultPartition.class);
    }

    @Test
    void testHybridFullResultPartitionOfNewModeCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_FULL, this.createTieredResultPartitionFactory());
        Assertions.assertThat((Object)resultPartition).isInstanceOf(TieredResultPartition.class);
    }

    @Test
    void testHybridSelectiveResultPartitionOfNewModeCreated() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_SELECTIVE, this.createTieredResultPartitionFactory());
        Assertions.assertThat((Object)resultPartition).isInstanceOf(TieredResultPartition.class);
    }

    @Test
    void testNoReleaseOnConsumptionForBoundedBlockingPartition() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING);
        resultPartition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)resultPartition.isReleased()).isFalse();
    }

    @Test
    void testNoReleaseOnConsumptionForSortMergePartition() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.BLOCKING, 1);
        resultPartition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)resultPartition.isReleased()).isFalse();
    }

    @Test
    void testNoReleaseOnConsumptionForHybridFullPartitionOfLegacyMode() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_FULL);
        resultPartition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)resultPartition.isReleased()).isFalse();
    }

    @Test
    void testNoReleaseOnConsumptionForHybridSelectivePartitionOfLegacyMode() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_SELECTIVE);
        resultPartition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)resultPartition.isReleased()).isFalse();
    }

    @Test
    void testNoReleaseOnConsumptionForHybridFullPartitionOfNewMode() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_FULL, this.createTieredResultPartitionFactory());
        resultPartition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)resultPartition.isReleased()).isFalse();
    }

    @Test
    void testNoReleaseOnConsumptionForHybridSelectivePartitionOfNewMode() {
        ResultPartition resultPartition = ResultPartitionFactoryTest.createResultPartition(ResultPartitionType.HYBRID_SELECTIVE, this.createTieredResultPartitionFactory());
        resultPartition.onConsumedSubpartition(0);
        Assertions.assertThat((boolean)resultPartition.isReleased()).isFalse();
    }

    private static ResultPartition createResultPartition(ResultPartitionType partitionType) {
        return ResultPartitionFactoryTest.createResultPartition(partitionType, Integer.MAX_VALUE, false, Optional.empty());
    }

    private static ResultPartition createResultPartition(ResultPartitionType partitionType, Optional<TieredResultPartitionFactory> tieredStorage) {
        return ResultPartitionFactoryTest.createResultPartition(partitionType, Integer.MAX_VALUE, false, tieredStorage);
    }

    private static ResultPartition createResultPartition(ResultPartitionType partitionType, int sortShuffleMinParallelism) {
        return ResultPartitionFactoryTest.createResultPartition(partitionType, sortShuffleMinParallelism, false, Optional.empty());
    }

    private static ResultPartition createResultPartition(ResultPartitionType partitionType, int sortShuffleMinParallelism, boolean isBroadcast, Optional<TieredResultPartitionFactory> tieredStorage) {
        ResultPartitionManager manager = new ResultPartitionManager();
        ResultPartitionFactory factory = new ResultPartitionFactory(manager, fileChannelManager, (BufferPoolFactory)new NetworkBufferPool(1, 64), new BatchShuffleReadBufferPool(640L, 64), Executors.newSingleThreadScheduledExecutor(), BoundedBlockingSubpartitionType.AUTO, 1, 1, 64, false, "LZ4", Integer.MAX_VALUE, 10, sortShuffleMinParallelism, false, 0, 256, Long.MAX_VALUE, tieredStorage);
        ResultPartitionDeploymentDescriptor descriptor = new ResultPartitionDeploymentDescriptor(PartitionDescriptorBuilder.newBuilder().setPartitionType(partitionType).setIsBroadcast(isBroadcast).build(), (ShuffleDescriptor)NettyShuffleDescriptorBuilder.newBuilder().buildLocal(), 1);
        Assertions.assertThat((int)descriptor.getNumberOfSubpartitions()).isEqualTo(1);
        ResultPartition partition = factory.create("test", 0, descriptor);
        manager.registerResultPartition(partition);
        return partition;
    }

    private Optional<TieredResultPartitionFactory> createTieredResultPartitionFactory() {
        TieredStorageConfiguration tieredStorageConfiguration = TieredStorageConfiguration.builder(null).build();
        TieredStorageResourceRegistry tieredStorageResourceRegistry = new TieredStorageResourceRegistry();
        TieredStorageNettyServiceImpl tieredStorageNettyService = new TieredStorageNettyServiceImpl(tieredStorageResourceRegistry);
        return Optional.of(new TieredResultPartitionFactory(tieredStorageConfiguration, tieredStorageNettyService, tieredStorageResourceRegistry));
    }
}

