/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.util.function.Function;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferListener;

public class TestingBufferListener
implements BufferListener {
    private final Function<Buffer, Boolean> notifyBufferAvailableFunction;
    private final Runnable notifyBufferDestroyedRunnable;

    private TestingBufferListener(Function<Buffer, Boolean> notifyBufferAvailableFunction, Runnable notifyBufferDestroyedRunnable) {
        this.notifyBufferAvailableFunction = notifyBufferAvailableFunction;
        this.notifyBufferDestroyedRunnable = notifyBufferDestroyedRunnable;
    }

    public boolean notifyBufferAvailable(Buffer buffer) {
        return this.notifyBufferAvailableFunction.apply(buffer);
    }

    public void notifyBufferDestroyed() {
        this.notifyBufferDestroyedRunnable.run();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Function<Buffer, Boolean> notifyBufferAvailableFunction = ignore -> false;
        private Runnable notifyBufferDestroyedRunnable = () -> {};

        public Builder setNotifyBufferAvailableFunction(Function<Buffer, Boolean> notifyBufferAvailableFunction) {
            this.notifyBufferAvailableFunction = notifyBufferAvailableFunction;
            return this;
        }

        public Builder setNotifyBufferDestroyedRunnable(Runnable notifyBufferDestroyedRunnable) {
            this.notifyBufferDestroyedRunnable = notifyBufferDestroyedRunnable;
            return this;
        }

        public TestingBufferListener build() {
            return new TestingBufferListener(this.notifyBufferAvailableFunction, this.notifyBufferDestroyedRunnable);
        }
    }
}

