/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureHandlingResult;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class FailureHandlingResultTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorExtension();

    FailureHandlingResultTest() {
    }

    @Test
    void testNormalFailureHandlingResult() throws Exception {
        Execution execution = FailureHandlingResultTest.createExecution((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor());
        HashSet<ExecutionVertexID> tasks = new HashSet<ExecutionVertexID>();
        tasks.add(execution.getVertex().getID());
        long delay = 1234L;
        RuntimeException error = new RuntimeException();
        long timestamp = System.currentTimeMillis();
        CompletableFuture<Map<String, String>> failureLabels = CompletableFuture.completedFuture(Collections.singletonMap("key", "value"));
        FailureHandlingResult result = FailureHandlingResult.restartable((Execution)execution, (Throwable)error, (long)timestamp, failureLabels, tasks, (long)1234L, (boolean)false);
        Assertions.assertThat((boolean)result.canRestart()).isTrue();
        Assertions.assertThat((long)1234L).isEqualTo(result.getRestartDelayMS());
        Assertions.assertThat(tasks).isEqualTo((Object)result.getVerticesToRestart());
        Assertions.assertThat((CompletableFuture)result.getFailureLabels()).isEqualTo(failureLabels);
        Assertions.assertThat((Throwable)result.getError()).isSameAs((Object)error);
        Assertions.assertThat((long)result.getTimestamp()).isEqualTo(timestamp);
        Assertions.assertThat((Optional)result.getFailedExecution()).isPresent();
        Assertions.assertThat(result.getFailedExecution().get()).isSameAs((Object)execution);
    }

    @Test
    void testRestartingSuppressedFailureHandlingResultWithNoCausingExecutionVertexId() {
        Exception error = new Exception("test error");
        long timestamp = System.currentTimeMillis();
        CompletableFuture<Map<String, String>> failureLabels = CompletableFuture.completedFuture(Collections.singletonMap("key", "value"));
        FailureHandlingResult result = FailureHandlingResult.unrecoverable(null, (Throwable)error, (long)timestamp, failureLabels, (boolean)false);
        Assertions.assertThat((boolean)result.canRestart()).isFalse();
        Assertions.assertThat((Throwable)result.getError()).isSameAs((Object)error);
        Assertions.assertThat((long)result.getTimestamp()).isEqualTo(timestamp);
        Assertions.assertThat((CompletableFuture)result.getFailureLabels()).isEqualTo(failureLabels);
        Assertions.assertThat((Optional)result.getFailedExecution()).isNotPresent();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FailureHandlingResult)result).getVerticesToRestart()).as("getVerticesToRestart is not allowed when restarting is suppressed", new Object[0])).isInstanceOf(IllegalStateException.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FailureHandlingResult)result).getRestartDelayMS()).as("getRestartDelayMS is not allowed when restarting is suppressed", new Object[0])).isInstanceOf(IllegalStateException.class);
    }

    static Execution createExecution(ScheduledExecutorService executor) throws Exception {
        DefaultExecutionGraph executionGraph = ExecutionGraphTestUtils.createExecutionGraph(executor, ExecutionGraphTestUtils.createNoOpVertex(1));
        return (Execution)executionGraph.getRegisteredExecutions().values().iterator().next();
    }
}

