/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraphDeploymentTest;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.apache.flink.types.Either;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

class DefaultExecutionGraphDeploymentWithBlobServerTest
extends DefaultExecutionGraphDeploymentTest {
    @TempDir
    Path temporaryFolder;
    private Set<byte[]> seenHashes = Collections.newSetFromMap(new ConcurrentHashMap());
    protected BlobServer blobServer = null;

    DefaultExecutionGraphDeploymentWithBlobServerTest() {
    }

    @BeforeEach
    public void setupBlobServer() throws IOException {
        Configuration config = new Configuration();
        config.setInteger(BlobServerOptions.OFFLOAD_MINSIZE, 0);
        this.blobServer = new AssertBlobServer(config, TempDirUtils.newFolder((Path)this.temporaryFolder), (BlobStore)new VoidBlobStore());
        this.blobWriter = this.blobServer;
        this.blobCache = this.blobServer;
        this.seenHashes.clear();
        this.blobServer.start();
    }

    @AfterEach
    public void shutdownBlobServer() throws IOException {
        if (this.blobServer != null) {
            this.blobServer.close();
        }
    }

    @Override
    protected void checkJobOffloaded(DefaultExecutionGraph eg) throws Exception {
        TaskDeploymentDescriptor.MaybeOffloaded serializedJobInformation = eg.getTaskDeploymentDescriptorFactory().getSerializedJobInformation();
        Assertions.assertThat((Object)serializedJobInformation).isInstanceOf(TaskDeploymentDescriptor.Offloaded.class);
        PermanentBlobKey blobKey = ((TaskDeploymentDescriptor.Offloaded)serializedJobInformation).serializedValueKey;
        Assertions.assertThatNoException().isThrownBy(() -> this.blobServer.getFile(eg.getJobID(), blobKey));
    }

    @Override
    protected void checkTaskOffloaded(ExecutionGraph eg, JobVertexID jobVertexId) throws Exception {
        Either taskInformationOrBlobKey = eg.getJobVertex(jobVertexId).getTaskInformationOrBlobKey();
        Assertions.assertThat((boolean)taskInformationOrBlobKey.isRight()).isTrue();
        this.blobServer.getFile(eg.getJobID(), (PermanentBlobKey)taskInformationOrBlobKey.right());
    }

    private class AssertBlobServer
    extends BlobServer {
        public AssertBlobServer(Configuration config, File storageDir, BlobStore blobStore) throws IOException {
            super(config, storageDir, blobStore);
        }

        public PermanentBlobKey putPermanent(JobID jobId, byte[] value) throws IOException {
            PermanentBlobKey key = super.putPermanent(jobId, value);
            Assertions.assertThat((boolean)DefaultExecutionGraphDeploymentWithBlobServerTest.this.seenHashes.add(key.getHash())).isTrue();
            return key;
        }
    }
}

