/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.NettyShuffleServiceFactory;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleEnvironmentContext;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;
import org.apache.flink.runtime.shuffle.ShuffleServiceFactory;
import org.apache.flink.runtime.shuffle.ShuffleServiceLoader;
import org.apache.flink.runtime.shuffle.ShuffleServiceOptions;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;

public class ShuffleServiceLoaderTest
extends TestLogger {
    @Test
    public void testLoadDefaultNettyShuffleServiceFactory() throws FlinkException {
        Configuration configuration = new Configuration();
        ShuffleServiceFactory shuffleServiceFactory = ShuffleServiceLoader.loadShuffleServiceFactory((Configuration)configuration);
        Assert.assertThat((String)"Loaded shuffle service factory is not the default netty implementation", (Object)shuffleServiceFactory, (Matcher)IsInstanceOf.instanceOf(NettyShuffleServiceFactory.class));
    }

    @Test
    public void testLoadCustomShuffleServiceFactory() throws FlinkException {
        Configuration configuration = new Configuration();
        configuration.setString(ShuffleServiceOptions.SHUFFLE_SERVICE_FACTORY_CLASS, "org.apache.flink.runtime.shuffle.ShuffleServiceLoaderTest$CustomShuffleServiceFactory");
        ShuffleServiceFactory shuffleServiceFactory = ShuffleServiceLoader.loadShuffleServiceFactory((Configuration)configuration);
        Assert.assertThat((String)"Loaded shuffle service factory is not the custom test implementation", (Object)shuffleServiceFactory, (Matcher)IsInstanceOf.instanceOf(CustomShuffleServiceFactory.class));
    }

    @Test(expected=FlinkException.class)
    public void testLoadShuffleServiceFactoryFailure() throws FlinkException {
        Configuration configuration = new Configuration();
        configuration.setString(ShuffleServiceOptions.SHUFFLE_SERVICE_FACTORY_CLASS, "org.apache.flink.runtime.shuffle.UnavailableShuffleServiceFactory");
        ShuffleServiceLoader.loadShuffleServiceFactory((Configuration)configuration);
    }

    public static class CustomShuffleServiceFactory
    implements ShuffleServiceFactory<ShuffleDescriptor, ResultPartitionWriter, IndexedInputGate> {
        public ShuffleMaster<ShuffleDescriptor> createShuffleMaster(ShuffleMasterContext shuffleMasterContext) {
            throw new UnsupportedOperationException();
        }

        public ShuffleEnvironment<ResultPartitionWriter, IndexedInputGate> createShuffleEnvironment(ShuffleEnvironmentContext shuffleEnvironmentContext) {
            throw new UnsupportedOperationException();
        }
    }
}

