/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.scheduler.adaptivebatch.AdaptiveBatchSchedulerFactory;
import org.apache.flink.runtime.scheduler.strategy.AllFinishedInputConsumableDecider;
import org.apache.flink.runtime.scheduler.strategy.DefaultInputConsumableDecider;
import org.apache.flink.runtime.scheduler.strategy.InputConsumableDecider;
import org.apache.flink.runtime.scheduler.strategy.PartialFinishedInputConsumableDecider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AdaptiveBatchSchedulerFactoryTest {
    AdaptiveBatchSchedulerFactoryTest() {
    }

    @Test
    void testNotOnlyConsumeFinishedPartitionWithSpeculativeEnable() {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.HYBRID_PARTITION_DATA_CONSUME_CONSTRAINT, (Object)JobManagerOptions.HybridPartitionDataConsumeConstraint.UNFINISHED_PRODUCERS);
        Assertions.assertThatThrownBy(() -> AdaptiveBatchSchedulerFactory.getOrDecideHybridPartitionDataConsumeConstraint((Configuration)configuration, (boolean)true)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testOnlyConsumeFinishedPartitionWillSetForSpeculativeEnable() {
        JobManagerOptions.HybridPartitionDataConsumeConstraint hybridPartitionDataConsumeConstraint = AdaptiveBatchSchedulerFactory.getOrDecideHybridPartitionDataConsumeConstraint((Configuration)new Configuration(), (boolean)true);
        Assertions.assertThat((boolean)hybridPartitionDataConsumeConstraint.isOnlyConsumeFinishedPartition()).isTrue();
    }

    @Test
    void testLoadInputConsumableDeciderFactory() {
        this.assertAndLoadInputConsumableDecider(JobManagerOptions.HybridPartitionDataConsumeConstraint.UNFINISHED_PRODUCERS, DefaultInputConsumableDecider.Factory.INSTANCE);
        this.assertAndLoadInputConsumableDecider(JobManagerOptions.HybridPartitionDataConsumeConstraint.ONLY_FINISHED_PRODUCERS, (InputConsumableDecider.Factory)PartialFinishedInputConsumableDecider.Factory.INSTANCE);
        this.assertAndLoadInputConsumableDecider(JobManagerOptions.HybridPartitionDataConsumeConstraint.ALL_PRODUCERS_FINISHED, (InputConsumableDecider.Factory)AllFinishedInputConsumableDecider.Factory.INSTANCE);
    }

    @Test
    void testMaxParallelismFallsBackToExecutionConfigDefaultParallelism() {
        Configuration configuration = new Configuration();
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setParallelism(5);
        Assertions.assertThat((int)AdaptiveBatchSchedulerFactory.getDefaultMaxParallelism((Configuration)configuration, (ExecutionConfig)executionConfig)).isEqualTo(5);
    }

    private void assertAndLoadInputConsumableDecider(JobManagerOptions.HybridPartitionDataConsumeConstraint hybridPartitionDataConsumeConstraint, InputConsumableDecider.Factory expectedFactory) {
        InputConsumableDecider.Factory factory = AdaptiveBatchSchedulerFactory.loadInputConsumableDeciderFactory((JobManagerOptions.HybridPartitionDataConsumeConstraint)hybridPartitionDataConsumeConstraint);
        Assertions.assertThat((Object)factory).isEqualTo((Object)expectedFactory);
    }
}

