/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.ExecutingTest;
import org.apache.flink.runtime.scheduler.adaptive.Failing;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.WaitingForResourcesTest;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.TestingAccessExecution;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FailingTest
extends TestLogger {
    private final Throwable testFailureCause = new RuntimeException();

    @Test
    public void testFailingStateOnEnter() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            this.createFailingState(ctx, meg);
            Assert.assertThat((Object)meg.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.FAILING));
            ctx.assertNoStateTransition();
        }
    }

    @Test
    public void testTransitionToFailedWhenFailingCompletes() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.FAILED)));
            meg.completeTerminationFuture(JobStatus.FAILED);
        }
    }

    @Test
    public void testTransitionToCancelingOnCancel() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectCanceling(WaitingForResourcesTest.assertNonNull());
            failing.cancel();
        }
    }

    @Test
    public void testTransitionToFinishedOnSuspend() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.SUSPENDED)));
            failing.suspend((Throwable)new RuntimeException("suspend"));
        }
    }

    @Test
    public void testIgnoreGlobalFailure() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            failing.handleGlobalFailure((Throwable)new RuntimeException());
            ctx.assertNoStateTransition();
        }
    }

    @Test
    public void testTaskFailuresAreIgnored() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            RuntimeException exception = new RuntimeException();
            TestingAccessExecution execution = TestingAccessExecution.newBuilder().withExecutionState(ExecutionState.FAILED).withErrorInfo(new ErrorInfo((Throwable)exception, System.currentTimeMillis())).build();
            meg.registerExecution(execution);
            TaskExecutionStateTransition update = ExecutingTest.createFailingStateTransition(execution.getAttemptId(), exception);
            failing.updateTaskExecutionState(update);
            ctx.assertNoStateTransition();
        }
    }

    @Test
    public void testStateDoesNotExposeGloballyTerminalExecutionGraph() throws Exception {
        try (MockFailingContext ctx = new MockFailingContext();){
            StateTrackingMockExecutionGraph meg = new StateTrackingMockExecutionGraph();
            Failing failing = this.createFailingState(ctx, meg);
            ctx.setExpectFinished(eg -> {});
            meg.completeTerminationFuture(JobStatus.FAILED);
            Assert.assertThat((Object)meg.getState(), (Matcher)CoreMatchers.is((Object)JobStatus.FAILED));
            Assert.assertThat((Object)failing.getJobStatus(), (Matcher)CoreMatchers.is((Object)JobStatus.FAILING));
            Assert.assertThat((Object)failing.getJob().getState(), (Matcher)CoreMatchers.is((Object)JobStatus.FAILING));
            Assert.assertThat((Object)failing.getJob().getStatusTimestamp(JobStatus.FAILED), (Matcher)CoreMatchers.is((Object)0L));
        }
    }

    private Failing createFailingState(MockFailingContext ctx, ExecutionGraph executionGraph) {
        ExecutionGraphHandler executionGraphHandler = new ExecutionGraphHandler(executionGraph, this.log, (Executor)ctx.getMainThreadExecutor(), ctx.getMainThreadExecutor());
        TestingOperatorCoordinatorHandler operatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
        executionGraph.transitionToRunning();
        return new Failing((Failing.Context)ctx, executionGraph, executionGraphHandler, (OperatorCoordinatorHandler)operatorCoordinatorHandler, this.log, this.testFailureCause, ClassLoader.getSystemClassLoader(), new ArrayList());
    }

    private static class MockFailingContext
    extends MockStateWithExecutionGraphContext
    implements Failing.Context {
        private final StateValidator<ExecutingTest.CancellingArguments> cancellingStateValidator = new StateValidator("cancelling");

        private MockFailingContext() {
        }

        public void setExpectCanceling(Consumer<ExecutingTest.CancellingArguments> asserter) {
            this.cancellingStateValidator.expectInput(asserter);
        }

        @Override
        public void archiveFailure(RootExceptionHistoryEntry failure) {
        }

        public void goToCanceling(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, List<ExceptionHistoryEntry> failureCollection) {
            this.cancellingStateValidator.validateInput(new ExecutingTest.CancellingArguments(executionGraph, executionGraphHandler, operatorCoordinatorHandler));
            this.hadStateTransition = true;
        }

        @Override
        public void close() throws Exception {
            super.close();
            this.cancellingStateValidator.close();
        }
    }
}

