/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.IterableUtils;

class TestingInputsLocationsRetriever
implements InputsLocationsRetriever {
    private final Map<ExecutionVertexID, Collection<ConsumedPartitionGroup>> vertexToConsumedPartitionGroups;
    private final Map<IntermediateResultPartitionID, ExecutionVertexID> partitionToProducer;
    private final Map<ExecutionVertexID, CompletableFuture<TaskManagerLocation>> taskManagerLocationsByVertex = new HashMap<ExecutionVertexID, CompletableFuture<TaskManagerLocation>>();

    TestingInputsLocationsRetriever(Map<ExecutionVertexID, Collection<ConsumedPartitionGroup>> vertexToConsumedPartitionGroups, Map<IntermediateResultPartitionID, ExecutionVertexID> partitionToProducer) {
        this.vertexToConsumedPartitionGroups = vertexToConsumedPartitionGroups;
        this.partitionToProducer = partitionToProducer;
    }

    public Collection<ConsumedPartitionGroup> getConsumedPartitionGroups(ExecutionVertexID executionVertexId) {
        return this.vertexToConsumedPartitionGroups.get(executionVertexId);
    }

    public Collection<ExecutionVertexID> getProducersOfConsumedPartitionGroup(ConsumedPartitionGroup consumedPartitionGroup) {
        return IterableUtils.toStream((Iterable)consumedPartitionGroup).map(this.partitionToProducer::get).collect(Collectors.toList());
    }

    public Optional<CompletableFuture<TaskManagerLocation>> getTaskManagerLocation(ExecutionVertexID executionVertexId) {
        return Optional.ofNullable(this.taskManagerLocationsByVertex.get(executionVertexId));
    }

    public void markScheduled(ExecutionVertexID executionVertexId) {
        this.taskManagerLocationsByVertex.put(executionVertexId, new CompletableFuture());
    }

    public void assignTaskManagerLocation(ExecutionVertexID executionVertexId) {
        this.assignTaskManagerLocation(executionVertexId, new LocalTaskManagerLocation());
    }

    public void assignTaskManagerLocation(ExecutionVertexID executionVertexId, TaskManagerLocation location) {
        this.taskManagerLocationsByVertex.compute(executionVertexId, (key, future) -> {
            if (future == null) {
                return CompletableFuture.completedFuture(location);
            }
            future.complete(location);
            return future;
        });
    }

    void failTaskManagerLocation(ExecutionVertexID executionVertexId, Throwable cause) {
        this.taskManagerLocationsByVertex.compute(executionVertexId, (key, future) -> {
            CompletableFuture futureToFail = future;
            if (futureToFail == null) {
                futureToFail = new CompletableFuture();
            }
            futureToFail.completeExceptionally(cause);
            return futureToFail;
        });
    }

    void cancelTaskManagerLocation(ExecutionVertexID executionVertexId) {
        this.taskManagerLocationsByVertex.compute(executionVertexId, (key, future) -> {
            CompletableFuture futureToCancel = future;
            if (futureToCancel == null) {
                futureToCancel = new CompletableFuture();
            }
            futureToCancel.cancel(true);
            return futureToCancel;
        });
    }

    static class Builder {
        private final Map<ExecutionVertexID, Collection<ConsumedPartitionGroup>> vertexToConsumedPartitionGroups = new HashMap<ExecutionVertexID, Collection<ConsumedPartitionGroup>>();
        private final Map<IntermediateResultPartitionID, ExecutionVertexID> partitionToProducer = new HashMap<IntermediateResultPartitionID, ExecutionVertexID>();

        Builder() {
        }

        public Builder connectConsumerToProducer(ExecutionVertexID consumer, ExecutionVertexID producer) {
            return this.connectConsumerToProducers(consumer, Collections.singletonList(producer));
        }

        public Builder connectConsumerToProducers(ExecutionVertexID consumer, List<ExecutionVertexID> producers) {
            return this.connectConsumersToProducers(Collections.singletonList(consumer), producers);
        }

        public Builder connectConsumersToProducers(List<ExecutionVertexID> consumers, List<ExecutionVertexID> producers) {
            TestingSchedulingTopology.ConnectionResult connectionResult = TestingSchedulingTopology.connectConsumersToProducersById(consumers, producers, new IntermediateDataSetID(), ResultPartitionType.PIPELINED);
            for (int i = 0; i < producers.size(); ++i) {
                this.partitionToProducer.put(connectionResult.getResultPartitions().get(i), producers.get(i));
            }
            for (ExecutionVertexID consumer : consumers) {
                Collection consumedPartitionGroups = this.vertexToConsumedPartitionGroups.computeIfAbsent(consumer, ignore -> new ArrayList());
                consumedPartitionGroups.add(connectionResult.getConsumedPartitionGroup());
            }
            return this;
        }

        public TestingInputsLocationsRetriever build() {
            return new TestingInputsLocationsRetriever(this.vertexToConsumedPartitionGroups, this.partitionToProducer);
        }
    }
}

