/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersion;
import org.apache.flink.runtime.scheduler.ExecutionVertexVersioner;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutionVertexVersionerTest
extends TestLogger {
    private static final ExecutionVertexID TEST_EXECUTION_VERTEX_ID1 = new ExecutionVertexID(new JobVertexID(), 0);
    private static final ExecutionVertexID TEST_EXECUTION_VERTEX_ID2 = new ExecutionVertexID(new JobVertexID(), 0);
    private static final Collection<ExecutionVertexID> TEST_ALL_EXECUTION_VERTEX_IDS = Arrays.asList(TEST_EXECUTION_VERTEX_ID1, TEST_EXECUTION_VERTEX_ID2);
    private ExecutionVertexVersioner executionVertexVersioner;

    @Before
    public void setUp() {
        this.executionVertexVersioner = new ExecutionVertexVersioner();
    }

    @Test
    public void isModifiedReturnsFalseIfVertexUnmodified() {
        ExecutionVertexVersion executionVertexVersion = this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        Assert.assertFalse((boolean)this.executionVertexVersioner.isModified(executionVertexVersion));
    }

    @Test
    public void isModifiedReturnsTrueIfVertexIsModified() {
        ExecutionVertexVersion executionVertexVersion = this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        Assert.assertTrue((boolean)this.executionVertexVersioner.isModified(executionVertexVersion));
    }

    @Test
    public void throwsExceptionIfVertexWasNeverModified() {
        try {
            this.executionVertexVersioner.isModified(new ExecutionVertexVersion(TEST_EXECUTION_VERTEX_ID1, 0L));
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)("Execution vertex " + TEST_EXECUTION_VERTEX_ID1 + " does not have a recorded version")));
        }
    }

    @Test
    public void getUnmodifiedVerticesAllVerticesModified() {
        HashSet executionVertexVersions = new HashSet(this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS).values());
        this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS);
        Set unmodifiedExecutionVertices = this.executionVertexVersioner.getUnmodifiedExecutionVertices(executionVertexVersions);
        Assert.assertThat((Object)unmodifiedExecutionVertices, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void getUnmodifiedVerticesNoVertexModified() {
        HashSet executionVertexVersions = new HashSet(this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS).values());
        Set unmodifiedExecutionVertices = this.executionVertexVersioner.getUnmodifiedExecutionVertices(executionVertexVersions);
        Assert.assertThat((Object)unmodifiedExecutionVertices, (Matcher)Matchers.containsInAnyOrder((Object[])new ExecutionVertexID[]{TEST_EXECUTION_VERTEX_ID1, TEST_EXECUTION_VERTEX_ID2}));
    }

    @Test
    public void getUnmodifiedVerticesPartOfVerticesModified() {
        HashSet executionVertexVersions = new HashSet(this.executionVertexVersioner.recordVertexModifications(TEST_ALL_EXECUTION_VERTEX_IDS).values());
        this.executionVertexVersioner.recordModification(TEST_EXECUTION_VERTEX_ID1);
        Set unmodifiedExecutionVertices = this.executionVertexVersioner.getUnmodifiedExecutionVertices(executionVertexVersions);
        Assert.assertThat((Object)unmodifiedExecutionVertices, (Matcher)Matchers.containsInAnyOrder((Object[])new ExecutionVertexID[]{TEST_EXECUTION_VERTEX_ID2}));
    }
}

