/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import org.apache.flink.metrics.AbstractHistogramTest;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogram;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogramStatistics;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.testcontainers.utility.ThrowingFunction;

@ExtendWith(value={TestLoggerExtension.class})
class DescriptiveStatisticsHistogramTest
extends AbstractHistogramTest {
    private static final double[] DATA = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};

    DescriptiveStatisticsHistogramTest() {
    }

    @Test
    void testDescriptiveHistogram() {
        int size = 10;
        this.testHistogram(size, (Histogram)new DescriptiveStatisticsHistogram(size));
    }

    @Test
    void testSerialization() throws Exception {
        DescriptiveStatisticsHistogramTest.testDuplication((ThrowingFunction<DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot>)((ThrowingFunction)original -> {
            byte[] bytes = InstantiationUtil.serializeObject((Object)original);
            return (DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot)InstantiationUtil.deserializeObject((byte[])bytes, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        }));
    }

    @Test
    void testCopy() throws Exception {
        DescriptiveStatisticsHistogramTest.testDuplication((ThrowingFunction<DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot>)((ThrowingFunction)DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot::copy));
    }

    private static void testDuplication(ThrowingFunction<DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot, DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot> duplicator) throws Exception {
        DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot original = new DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot();
        original.evaluate(DATA);
        DescriptiveStatisticsHistogramTest.assertOperations(original);
        DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot copy = (DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot)duplicator.apply((Object)original);
        DescriptiveStatisticsHistogramTest.assertOperations(copy);
    }

    private static void assertOperations(DescriptiveStatisticsHistogramStatistics.CommonMetricsSnapshot statistics) {
        Assertions.assertThat((double)statistics.getPercentile(0.5)).isEqualTo(1.0);
        Assertions.assertThat((long)statistics.getCount()).isEqualTo(9L);
        Assertions.assertThat((double)statistics.getMin()).isEqualTo(1.0);
        Assertions.assertThat((double)statistics.getMax()).isEqualTo(9.0);
        Assertions.assertThat((double)statistics.getMean()).isEqualTo(5.0);
        Assertions.assertThat((double)statistics.getStandardDeviation()).isCloseTo(2.7, Offset.offset((Number)0.5));
        Assertions.assertThat((double[])statistics.getValues()).containsExactly(DATA);
    }
}

