/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.flink.runtime.iterative.concurrent.Broker;
import org.apache.flink.runtime.iterative.concurrent.StringPair;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class BrokerTest {
    @Test
    public void mediation() throws Exception {
        Random random = new Random();
        for (int n = 0; n < 20; ++n) {
            this.mediate(random.nextInt(10) + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mediate(int subtasks) throws InterruptedException, ExecutionException {
        ExecutorService executorService = Executors.newFixedThreadPool(subtasks * 2);
        try {
            ArrayList<Callable<StringPair>> tasks = new ArrayList<Callable<StringPair>>();
            Broker broker = new Broker();
            for (int subtask = 0; subtask < subtasks; ++subtask) {
                tasks.add(new IterationHead((Broker<String>)broker, subtask, "value" + subtask));
                tasks.add(new IterationTail((Broker<String>)broker, subtask));
            }
            Collections.shuffle(tasks);
            int numSuccessfulHandovers = 0;
            for (Future future : executorService.invokeAll(tasks)) {
                StringPair stringPair = (StringPair)future.get();
                if (stringPair == null) continue;
                Assert.assertEquals((Object)("value" + stringPair.getFirst()), (Object)stringPair.getSecond());
                ++numSuccessfulHandovers;
            }
            Assert.assertEquals((long)subtasks, (long)numSuccessfulHandovers);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    class IterationTail
    implements Callable<StringPair> {
        private final Random random;
        private final Broker<String> broker;
        private final String key;

        IterationTail(Broker<String> broker, Integer key) {
            this.broker = broker;
            this.key = String.valueOf(key);
            this.random = new Random();
        }

        @Override
        public StringPair call() throws Exception {
            Thread.sleep(this.random.nextInt(10));
            String value = (String)this.broker.getAndRemove(this.key);
            Preconditions.checkNotNull((Object)value);
            return new StringPair(this.key, value);
        }
    }

    class IterationHead
    implements Callable<StringPair> {
        private final Random random;
        private final Broker<String> broker;
        private final String key;
        private final String value;

        IterationHead(Broker<String> broker, Integer key, String value) {
            this.broker = broker;
            this.key = String.valueOf(key);
            this.value = value;
            this.random = new Random();
        }

        @Override
        public StringPair call() throws Exception {
            Thread.sleep(this.random.nextInt(10));
            this.broker.handIn(this.key, (Object)this.value);
            Thread.sleep(this.random.nextInt(10));
            return null;
        }
    }
}

