/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.hybrid.HsDataView;
import org.apache.flink.util.function.FunctionWithException;

public class TestingHsDataView
implements HsDataView {
    public static final TestingHsDataView NO_OP = TestingHsDataView.builder().build();
    private final FunctionWithException<Integer, Optional<ResultSubpartition.BufferAndBacklog>, Throwable> consumeBufferFunction;
    private final Function<Integer, Buffer.DataType> peekNextToConsumeDataTypeFunction;
    private final Supplier<Integer> getBacklogSupplier;
    private final Runnable releaseDataViewRunnable;

    private TestingHsDataView(FunctionWithException<Integer, Optional<ResultSubpartition.BufferAndBacklog>, Throwable> consumeBufferFunction, Function<Integer, Buffer.DataType> peekNextToConsumeDataTypeFunction, Supplier<Integer> getBacklogSupplier, Runnable releaseDataViewRunnable) {
        this.consumeBufferFunction = consumeBufferFunction;
        this.peekNextToConsumeDataTypeFunction = peekNextToConsumeDataTypeFunction;
        this.getBacklogSupplier = getBacklogSupplier;
        this.releaseDataViewRunnable = releaseDataViewRunnable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<ResultSubpartition.BufferAndBacklog> consumeBuffer(int nextBufferToConsume) throws Throwable {
        return (Optional)this.consumeBufferFunction.apply((Object)nextBufferToConsume);
    }

    public Buffer.DataType peekNextToConsumeDataType(int nextBufferToConsume) {
        return this.peekNextToConsumeDataTypeFunction.apply(nextBufferToConsume);
    }

    public int getBacklog() {
        return this.getBacklogSupplier.get();
    }

    public void releaseDataView() {
        this.releaseDataViewRunnable.run();
    }

    public static class Builder {
        private FunctionWithException<Integer, Optional<ResultSubpartition.BufferAndBacklog>, Throwable> consumeBufferFunction = ignore -> Optional.empty();
        private Function<Integer, Buffer.DataType> peekNextToConsumeDataTypeFunction = ignore -> Buffer.DataType.NONE;
        private Supplier<Integer> getBacklogSupplier = () -> 0;
        private Runnable releaseDataViewRunnable = () -> {};

        private Builder() {
        }

        public Builder setConsumeBufferFunction(FunctionWithException<Integer, Optional<ResultSubpartition.BufferAndBacklog>, Throwable> consumeBufferFunction) {
            this.consumeBufferFunction = consumeBufferFunction;
            return this;
        }

        public Builder setPeekNextToConsumeDataTypeFunction(Function<Integer, Buffer.DataType> peekNextToConsumeDataTypeFunction) {
            this.peekNextToConsumeDataTypeFunction = peekNextToConsumeDataTypeFunction;
            return this;
        }

        public Builder setGetBacklogSupplier(Supplier<Integer> getBacklogSupplier) {
            this.getBacklogSupplier = getBacklogSupplier;
            return this;
        }

        public Builder setReleaseDataViewRunnable(Runnable releaseDataViewRunnable) {
            this.releaseDataViewRunnable = releaseDataViewRunnable;
            return this;
        }

        public TestingHsDataView build() {
            return new TestingHsDataView(this.consumeBufferFunction, this.peekNextToConsumeDataTypeFunction, this.getBacklogSupplier, this.releaseDataViewRunnable);
        }
    }
}

