/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.util.TestCounter;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.BufferIndexAndChannel;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HsOutputMetrics;
import org.assertj.core.api.Assertions;

public class HybridShuffleTestUtils {
    public static final int MEMORY_SEGMENT_SIZE = 128;

    public static List<BufferIndexAndChannel> createBufferIndexAndChannelsList(int subpartitionId, int ... bufferIndexes) {
        ArrayList<BufferIndexAndChannel> bufferIndexAndChannels = new ArrayList<BufferIndexAndChannel>();
        for (int bufferIndex : bufferIndexes) {
            bufferIndexAndChannels.add(new BufferIndexAndChannel(bufferIndex, subpartitionId));
        }
        return bufferIndexAndChannels;
    }

    public static Deque<BufferIndexAndChannel> createBufferIndexAndChannelsDeque(int subpartitionId, int ... bufferIndexes) {
        ArrayDeque<BufferIndexAndChannel> bufferIndexAndChannels = new ArrayDeque<BufferIndexAndChannel>();
        for (int bufferIndex : bufferIndexes) {
            bufferIndexAndChannels.add(new BufferIndexAndChannel(bufferIndex, subpartitionId));
        }
        return bufferIndexAndChannels;
    }

    public static Buffer createBuffer(int bufferSize, boolean isEvent) {
        return new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), FreeingBufferRecycler.INSTANCE, isEvent ? Buffer.DataType.EVENT_BUFFER : Buffer.DataType.DATA_BUFFER, bufferSize);
    }

    public static BufferBuilder createBufferBuilder(int bufferSize) {
        return new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), FreeingBufferRecycler.INSTANCE);
    }

    public static HsOutputMetrics createTestingOutputMetrics() {
        return new HsOutputMetrics((Counter)new TestCounter(), (Counter)new TestCounter());
    }

    public static HsFileDataIndexImpl.InternalRegion createSingleUnreleasedRegion(int firstBufferIndex, long firstBufferOffset, int numBuffersPerRegion) {
        return new HsFileDataIndexImpl.InternalRegion(firstBufferIndex, firstBufferOffset, numBuffersPerRegion, new boolean[numBuffersPerRegion]);
    }

    public static List<HsFileDataIndexImpl.InternalRegion> createAllUnreleasedRegions(int firstBufferIndex, long firstBufferOffset, int numBuffersPerRegion, int numRegions) {
        ArrayList<HsFileDataIndexImpl.InternalRegion> regions = new ArrayList<HsFileDataIndexImpl.InternalRegion>();
        int bufferIndex = firstBufferIndex;
        long bufferOffset = firstBufferOffset;
        for (int i = 0; i < numRegions; ++i) {
            regions.add(new HsFileDataIndexImpl.InternalRegion(bufferIndex, bufferOffset, numBuffersPerRegion, new boolean[numBuffersPerRegion]));
            bufferIndex += numBuffersPerRegion;
            bufferOffset += bufferOffset;
        }
        return regions;
    }

    public static void assertRegionEquals(HsFileDataIndexImpl.InternalRegion expected, HsFileDataIndexImpl.InternalRegion region) {
        Assertions.assertThat((int)region.getFirstBufferIndex()).isEqualTo(expected.getFirstBufferIndex());
        Assertions.assertThat((long)region.getFirstBufferOffset()).isEqualTo(expected.getFirstBufferOffset());
        Assertions.assertThat((int)region.getNumBuffers()).isEqualTo(region.getNumBuffers());
        Assertions.assertThat((boolean[])region.getReleased()).isEqualTo((Object)region.getReleased());
    }
}

