/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.PullingAsyncDataInput;
import org.apache.flink.runtime.io.network.api.StopMode;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.partition.NoOpResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateTestBase;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateTest;
import org.apache.flink.runtime.io.network.partition.consumer.TestInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.UnionInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.UnknownInputChannel;
import org.apache.flink.runtime.util.NettyShuffleDescriptorBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class UnionInputGateTest
extends InputGateTestBase {
    @Test(timeout=120000L)
    public void testBasicGetNextLogic() throws Exception {
        SingleInputGate ig1 = this.createInputGate(3);
        SingleInputGate ig2 = this.createInputGate(5);
        UnionInputGate union = new UnionInputGate((IndexedInputGate[])new SingleInputGate[]{ig1, ig2});
        Assert.assertEquals((long)(ig1.getNumberOfInputChannels() + ig2.getNumberOfInputChannels()), (long)union.getNumberOfInputChannels());
        TestInputChannel[][] inputChannels = new TestInputChannel[][]{TestInputChannel.createInputChannels(ig1, 3), TestInputChannel.createInputChannels(ig2, 5)};
        inputChannels[0][0].readBuffer();
        inputChannels[0][0].readEndOfData();
        inputChannels[0][0].readEndOfPartitionEvent();
        inputChannels[1][2].readBuffer();
        inputChannels[1][2].readEndOfData();
        inputChannels[1][2].readEndOfPartitionEvent();
        inputChannels[1][0].readBuffer();
        inputChannels[1][1].readBuffer();
        inputChannels[0][1].readBuffer();
        inputChannels[1][3].readBuffer();
        inputChannels[0][1].readEndOfData();
        inputChannels[1][3].readEndOfData();
        inputChannels[0][1].readEndOfPartitionEvent();
        inputChannels[1][3].readEndOfPartitionEvent();
        inputChannels[0][2].readBuffer();
        inputChannels[0][2].readEndOfData();
        inputChannels[0][2].readEndOfPartitionEvent();
        inputChannels[1][4].readBuffer();
        inputChannels[1][4].readEndOfData();
        inputChannels[1][1].readEndOfData();
        inputChannels[1][0].readEndOfData();
        inputChannels[1][4].readEndOfPartitionEvent();
        inputChannels[1][1].readEndOfPartitionEvent();
        inputChannels[1][0].readEndOfPartitionEvent();
        ig1.notifyChannelNonEmpty((InputChannel)inputChannels[0][0]);
        ig1.notifyChannelNonEmpty((InputChannel)inputChannels[0][1]);
        ig1.notifyChannelNonEmpty((InputChannel)inputChannels[0][2]);
        ig2.notifyChannelNonEmpty((InputChannel)inputChannels[1][0]);
        ig2.notifyChannelNonEmpty((InputChannel)inputChannels[1][1]);
        ig2.notifyChannelNonEmpty((InputChannel)inputChannels[1][2]);
        ig2.notifyChannelNonEmpty((InputChannel)inputChannels[1][3]);
        ig2.notifyChannelNonEmpty((InputChannel)inputChannels[1][4]);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 0, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 3, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 1, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 4, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 2, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 5, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 0, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 6, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 1, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, true, 7, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 2, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 3, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 0, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 4, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 1, true);
        Assert.assertEquals((Object)PullingAsyncDataInput.EndOfDataStatus.NOT_END_OF_DATA, (Object)union.hasReceivedEndOfData());
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 5, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 2, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 6, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 7, true);
        Assert.assertEquals((Object)PullingAsyncDataInput.EndOfDataStatus.DRAINED, (Object)union.hasReceivedEndOfData());
        Assert.assertFalse((boolean)union.isFinished());
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 3, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 4, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 5, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 6, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)union, false, 7, false);
        Assert.assertTrue((boolean)union.isFinished());
        Assert.assertFalse((boolean)union.getNext().isPresent());
    }

    @Test
    public void testDrainFlagComputation() throws Exception {
        SingleInputGate inputGate1 = this.createInputGate();
        SingleInputGate inputGate2 = this.createInputGate();
        InputChannel[] inputChannels1 = new TestInputChannel[]{new TestInputChannel(inputGate1, 0), new TestInputChannel(inputGate1, 1)};
        inputGate1.setInputChannels(inputChannels1);
        InputChannel[] inputChannels2 = new TestInputChannel[]{new TestInputChannel(inputGate2, 0), new TestInputChannel(inputGate2, 1)};
        inputGate2.setInputChannels(inputChannels2);
        inputChannels1[1].readEndOfData(StopMode.DRAIN);
        inputChannels1[0].readEndOfData(StopMode.NO_DRAIN);
        inputChannels2[1].readEndOfData(StopMode.DRAIN);
        inputChannels2[0].readEndOfData(StopMode.DRAIN);
        UnionInputGate unionInputGate = new UnionInputGate(new IndexedInputGate[]{inputGate1, inputGate2});
        inputGate1.notifyChannelNonEmpty(inputChannels1[0]);
        inputGate1.notifyChannelNonEmpty(inputChannels1[1]);
        inputGate2.notifyChannelNonEmpty(inputChannels2[0]);
        inputGate2.notifyChannelNonEmpty(inputChannels2[1]);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)unionInputGate, false, 0, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)unionInputGate, false, 2, true);
        Assert.assertEquals((Object)PullingAsyncDataInput.EndOfDataStatus.NOT_END_OF_DATA, (Object)unionInputGate.hasReceivedEndOfData());
        SingleInputGateTest.verifyBufferOrEvent((InputGate)unionInputGate, false, 1, true);
        SingleInputGateTest.verifyBufferOrEvent((InputGate)unionInputGate, false, 3, true);
        Assert.assertEquals((Object)PullingAsyncDataInput.EndOfDataStatus.STOPPED, (Object)unionInputGate.hasReceivedEndOfData());
    }

    @Test
    public void testIsAvailable() throws Exception {
        SingleInputGate inputGate1 = this.createInputGate(1);
        TestInputChannel inputChannel1 = new TestInputChannel(inputGate1, 0);
        inputGate1.setInputChannels(new InputChannel[]{inputChannel1});
        SingleInputGate inputGate2 = this.createInputGate(1);
        TestInputChannel inputChannel2 = new TestInputChannel(inputGate2, 0);
        inputGate2.setInputChannels(new InputChannel[]{inputChannel2});
        this.testIsAvailable((InputGate)new UnionInputGate(new IndexedInputGate[]{inputGate1, inputGate2}), inputGate1, inputChannel1);
    }

    @Test
    public void testAvailability() throws IOException, InterruptedException {
        SingleInputGate inputGate1 = this.createInputGate(1);
        TestInputChannel inputChannel1 = new TestInputChannel(inputGate1, 0, false, true);
        inputGate1.setInputChannels(new InputChannel[]{inputChannel1});
        SingleInputGate inputGate2 = this.createInputGate(1);
        TestInputChannel inputChannel2 = new TestInputChannel(inputGate2, 0, false, true);
        inputGate2.setInputChannels(new InputChannel[]{inputChannel2});
        UnionInputGate inputGate = new UnionInputGate(new IndexedInputGate[]{inputGate1, inputGate2});
        inputChannel1.read(BufferBuilderTestUtils.buildSomeBuffer(1));
        Assert.assertTrue((boolean)inputGate.getAvailableFuture().isDone());
        inputChannel1.read(BufferBuilderTestUtils.buildSomeBuffer(2));
        Assert.assertTrue((boolean)inputGate.getAvailableFuture().isDone());
        Assert.assertEquals((long)1L, (long)((BufferOrEvent)inputGate.getNext().get()).getBuffer().getSize());
        Assert.assertTrue((boolean)inputGate.getAvailableFuture().isDone());
    }

    @Test
    public void testIsAvailableAfterFinished() throws Exception {
        SingleInputGate inputGate1 = this.createInputGate(1);
        TestInputChannel inputChannel1 = new TestInputChannel(inputGate1, 0);
        inputGate1.setInputChannels(new InputChannel[]{inputChannel1});
        SingleInputGate inputGate2 = this.createInputGate(1);
        TestInputChannel inputChannel2 = new TestInputChannel(inputGate2, 0);
        inputGate2.setInputChannels(new InputChannel[]{inputChannel2});
        this.testIsAvailableAfterFinished((InputGate)new UnionInputGate(new IndexedInputGate[]{inputGate1, inputGate2}), () -> {
            inputChannel1.readEndOfPartitionEvent();
            inputChannel2.readEndOfPartitionEvent();
            inputGate1.notifyChannelNonEmpty((InputChannel)inputChannel1);
            inputGate2.notifyChannelNonEmpty((InputChannel)inputChannel2);
        });
    }

    @Test
    public void testUpdateInputChannel() throws Exception {
        SingleInputGate inputGate1 = this.createInputGate(1);
        TestInputChannel inputChannel1 = new TestInputChannel(inputGate1, 0);
        inputGate1.setInputChannels(new InputChannel[]{inputChannel1});
        SingleInputGate inputGate2 = this.createInputGate(1);
        SingleInputGateTest.TestingResultPartitionManager partitionManager = new SingleInputGateTest.TestingResultPartitionManager((ResultSubpartitionView)new NoOpResultSubpartitionView());
        UnknownInputChannel unknownInputChannel2 = InputChannelBuilder.newBuilder().setPartitionManager(partitionManager).buildUnknownChannel(inputGate2);
        inputGate2.setInputChannels(new InputChannel[]{unknownInputChannel2});
        UnionInputGate unionInputGate = new UnionInputGate(new IndexedInputGate[]{inputGate1, inputGate2});
        ResultPartitionID resultPartitionID = unknownInputChannel2.getPartitionId();
        ResourceID location = ResourceID.generate();
        inputGate2.updateInputChannel(location, NettyShuffleDescriptorBuilder.createRemoteWithIdAndLocation(resultPartitionID.getPartitionId(), location));
        Assert.assertThat((Object)unionInputGate.getChannel(0), (Matcher)Matchers.is((Object)((Object)inputChannel1)));
        Assert.assertThat((Object)unionInputGate.getChannel(1), (Matcher)Matchers.is((Object)inputGate2.getChannel(0)));
    }

    @Test
    public void testGetChannelWithShiftedGateIndexes() {
        this.gateIndex = 2;
        SingleInputGate inputGate1 = this.createInputGate(1);
        TestInputChannel inputChannel1 = new TestInputChannel(inputGate1, 0);
        inputGate1.setInputChannels(new InputChannel[]{inputChannel1});
        SingleInputGate inputGate2 = this.createInputGate(1);
        TestInputChannel inputChannel2 = new TestInputChannel(inputGate2, 0);
        inputGate2.setInputChannels(new InputChannel[]{inputChannel2});
        UnionInputGate unionInputGate = new UnionInputGate(new IndexedInputGate[]{inputGate1, inputGate2});
        Assert.assertThat((Object)unionInputGate.getChannel(0), (Matcher)Matchers.is((Object)((Object)inputChannel1)));
        Assert.assertThat((Object)unionInputGate.getChannel(1), (Matcher)Matchers.is((Object)((Object)inputChannel2)));
    }

    @Test
    public void testEmptyPull() throws IOException, InterruptedException {
        SingleInputGate inputGate1 = this.createInputGate(1);
        TestInputChannel inputChannel1 = new TestInputChannel(inputGate1, 0, false, true);
        inputGate1.setInputChannels(new InputChannel[]{inputChannel1});
        SingleInputGate inputGate2 = this.createInputGate(1);
        TestInputChannel inputChannel2 = new TestInputChannel(inputGate2, 0, false, true);
        inputGate2.setInputChannels(new InputChannel[]{inputChannel2});
        UnionInputGate inputGate = new UnionInputGate(new IndexedInputGate[]{inputGate1, inputGate2});
        inputChannel1.notifyChannelNonEmpty();
        Assert.assertTrue((boolean)inputGate.getAvailableFuture().isDone());
        Assert.assertFalse((boolean)inputGate.pollNext().isPresent());
        Assert.assertFalse((boolean)inputGate.getAvailableFuture().isDone());
    }
}

