/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.util.ArrayList;
import org.apache.flink.runtime.io.disk.FileChannelOutputView;
import org.apache.flink.runtime.io.disk.SeekableFileChannelInputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.junit.Assert;
import org.junit.Test;

public class SeekableFileChannelInputViewTest {
    @Test
    public void testSeek() {
        int PAGE_SIZE = 16384;
        int NUM_RECORDS = 120000;
        try (IOManagerAsync ioManager = new IOManagerAsync();){
            int i;
            MemoryManager memMan = MemoryManagerBuilder.newBuilder().setMemorySize(65536L).setPageSize(16384).build();
            ArrayList memory = new ArrayList();
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            FileIOChannel.ID channel = ioManager.createChannel();
            BlockChannelWriter writer = ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView out = new FileChannelOutputView(writer, memMan, memory, memMan.getPageSize());
            for (int i2 = 0; i2 < 120000; i2 += 4) {
                out.writeInt(i2);
            }
            out.close();
            Assert.assertTrue((boolean)memMan.verifyEmpty());
            memMan.allocatePages((Object)new DummyInvokable(), memory, 4);
            SeekableFileChannelInputView in = new SeekableFileChannelInputView((IOManager)ioManager, channel, memMan, memory, out.getBytesInLatestSegment());
            for (int i3 = 0; i3 < 120000; i3 += 4) {
                Assert.assertEquals((long)i3, (long)in.readInt());
            }
            try {
                in.readInt();
                Assert.fail((String)"should throw EOF exception");
            }
            catch (EOFException i3) {
                // empty catch block
            }
            in.seek((long)i);
            for (i = 36864; i < 120000; i += 4) {
                Assert.assertEquals((long)i, (long)in.readInt());
            }
            try {
                in.readInt();
                Assert.fail((String)"should throw EOF exception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            in.seek((long)i);
            for (i = 119996; i < 120000; i += 4) {
                Assert.assertEquals((long)i, (long)in.readInt());
            }
            try {
                in.readInt();
                Assert.fail((String)"should throw EOF exception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            in.seek((long)i);
            for (i = 0; i < 120000; i += 4) {
                Assert.assertEquals((long)i, (long)in.readInt());
            }
            try {
                in.readInt();
                Assert.fail((String)"should throw EOF exception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            in.seek((long)i);
            for (i = 16384; i < 120000; i += 4) {
                Assert.assertEquals((long)i, (long)in.readInt());
            }
            try {
                in.readInt();
                Assert.fail((String)"should throw EOF exception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            in.seek((long)i);
            for (i = 49152; i < 120000; i += 4) {
                Assert.assertEquals((long)i, (long)in.readInt());
            }
            try {
                in.readInt();
                Assert.fail((String)"should throw EOF exception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            i = 120000;
            in.seek((long)i);
            try {
                in.readInt();
                Assert.fail((String)"should throw EOF exception");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            try {
                in.seek(-10L);
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                in.seek(120001L);
                Assert.fail((String)"should throw an exception");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

