/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStoreTestUtils;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorResource;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutorServiceAdapter;
import org.junit.ClassRule;
import org.junit.Test;

public class MemoryExecutionGraphInfoStoreITCase
extends TestLogger {
    @ClassRule
    public static final TestExecutorResource<ScheduledExecutorService> EXECUTOR_RESOURCE = TestingUtils.defaultExecutorResource();

    @Test
    public void testPutSuspendedJobOnClusterShutdown() throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.JOB_STORE_TYPE, (Object)JobManagerOptions.JobStoreType.Memory);
        try (ExecutionGraphInfoStoreTestUtils.PersistingMiniCluster miniCluster = new ExecutionGraphInfoStoreTestUtils.PersistingMiniCluster(new MiniClusterConfiguration.Builder().withRandomPorts().setConfiguration(configuration).build(), (ScheduledExecutor)new ScheduledExecutorServiceAdapter((ScheduledExecutorService)EXECUTOR_RESOURCE.getExecutor()));){
            miniCluster.start();
            JobVertex vertex = new JobVertex("blockingVertex");
            vertex.setParallelism(1);
            vertex.setInvokableClass(ExecutionGraphInfoStoreTestUtils.SignallingBlockingNoOpInvokable.class);
            JobGraph jobGraph = JobGraphTestUtils.streamingJobGraph(vertex);
            miniCluster.submitJob(jobGraph);
            ExecutionGraphInfoStoreTestUtils.SignallingBlockingNoOpInvokable.LATCH.await();
        }
    }
}

