/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.util.Random;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutor;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorFactory;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.storage.JobManagerCheckpointStorage;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class ChannelStateWriteRequestExecutorFactoryTest {
    private static final CheckpointStorage CHECKPOINT_STORAGE = new JobManagerCheckpointStorage();

    @Test
    void testReuseExecutorForSameJobId() {
        this.assertReuseExecutor(1);
        this.assertReuseExecutor(2);
        this.assertReuseExecutor(3);
        this.assertReuseExecutor(5);
        this.assertReuseExecutor(10);
    }

    private void assertReuseExecutor(int maxSubtasksPerChannelStateFile) {
        JobID JOB_ID = new JobID();
        Random RANDOM = new Random();
        ChannelStateWriteRequestExecutorFactory executorFactory = new ChannelStateWriteRequestExecutorFactory(JOB_ID);
        int numberOfTasks = 100;
        ChannelStateWriteRequestExecutor currentExecutor = null;
        for (int i = 0; i < numberOfTasks; ++i) {
            ChannelStateWriteRequestExecutor newExecutor = executorFactory.getOrCreateExecutor(new JobVertexID(), RANDOM.nextInt(numberOfTasks), CHECKPOINT_STORAGE, maxSubtasksPerChannelStateFile);
            if (i % maxSubtasksPerChannelStateFile == 0) {
                ((ObjectAssert)Assertions.assertThat((Object)newExecutor).as("Factory should create the new executor.", new Object[0])).isNotSameAs(currentExecutor);
                currentExecutor = newExecutor;
                continue;
            }
            ((ObjectAssert)Assertions.assertThat((Object)newExecutor).as("Factory should reuse the old executor.", new Object[0])).isSameAs(currentExecutor);
        }
    }
}

