/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.SnapshotType;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.RestoreMode;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.runtime.state.testutils.EmptyStreamStateHandle;
import org.apache.flink.runtime.state.testutils.TestCompletedCheckpointStorageLocation;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CompletedCheckpointTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testCompareCheckpointsWithDifferentOrder() {
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(new JobID(), 1L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        checkpoints1.add(checkpoint2);
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint2);
        checkpoints2.add(checkpoint1);
        checkpoints2.add(checkpoint2);
        Assert.assertFalse((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2));
    }

    @Test
    public void testCompareCheckpointsWithSameOrder() {
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(new JobID(), 1L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        checkpoints1.add(checkpoint2);
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint1);
        checkpoints2.add(checkpoint2);
        checkpoints2.add(checkpoint1);
        Assert.assertTrue((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2));
    }

    @Test
    public void testCompareCheckpointsWithSameJobID() {
        JobID jobID = new JobID();
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(jobID, 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(jobID, 1L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint2);
        Assert.assertFalse((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2));
    }

    @Test
    public void testCompareCheckpointsWithSameCheckpointId() {
        JobID jobID1 = new JobID();
        JobID jobID2 = new JobID();
        CompletedCheckpoint checkpoint1 = new CompletedCheckpoint(jobID1, 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        CompletedCheckpoint checkpoint2 = new CompletedCheckpoint(jobID2, 0L, 0L, 1L, new HashMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        ArrayList<CompletedCheckpoint> checkpoints1 = new ArrayList<CompletedCheckpoint>();
        checkpoints1.add(checkpoint1);
        ArrayList<CompletedCheckpoint> checkpoints2 = new ArrayList<CompletedCheckpoint>();
        checkpoints2.add(checkpoint2);
        Assert.assertFalse((boolean)CompletedCheckpoint.checkpointsMatch(checkpoints1, checkpoints2));
    }

    @Test
    public void testRegisterStatesAtRegistry() {
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
        operatorStates.put(new OperatorID(), state);
        CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, operatorStates, Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), null);
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        checkpoint.registerSharedStatesAfterRestored((SharedStateRegistry)sharedStateRegistry, RestoreMode.DEFAULT);
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).registerSharedStates((SharedStateRegistry)sharedStateRegistry, 0L);
    }

    @Test
    public void testCleanUpOnSubsume() throws Exception {
        OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
        HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
        operatorStates.put(new OperatorID(), state);
        EmptyStreamStateHandle metadata = new EmptyStreamStateHandle();
        TestCompletedCheckpointStorageLocation location = new TestCompletedCheckpointStorageLocation(metadata, "ptr");
        CheckpointProperties props = new CheckpointProperties(false, (SnapshotType)CheckpointType.CHECKPOINT, true, false, false, false, false, false);
        CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, operatorStates, Collections.emptyList(), props, (CompletedCheckpointStorageLocation)location, null);
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        checkpoint.registerSharedStatesAfterRestored((SharedStateRegistry)sharedStateRegistry, RestoreMode.DEFAULT);
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).registerSharedStates((SharedStateRegistry)sharedStateRegistry, 0L);
        checkpoint.markAsDiscardedOnSubsume().discard();
        ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).discardState();
        Assert.assertTrue((boolean)location.isDisposed());
        Assert.assertTrue((boolean)metadata.isDisposed());
    }

    @Test
    public void testCleanUpOnShutdown() throws Exception {
        JobStatus[] terminalStates;
        for (JobStatus status : terminalStates = new JobStatus[]{JobStatus.FINISHED, JobStatus.CANCELED, JobStatus.FAILED, JobStatus.SUSPENDED}) {
            OperatorState state = (OperatorState)Mockito.mock(OperatorState.class);
            HashMap<OperatorID, OperatorState> operatorStates = new HashMap<OperatorID, OperatorState>();
            operatorStates.put(new OperatorID(), state);
            EmptyStreamStateHandle retainedHandle = new EmptyStreamStateHandle();
            TestCompletedCheckpointStorageLocation retainedLocation = new TestCompletedCheckpointStorageLocation(retainedHandle, "ptr");
            CheckpointProperties retainProps = new CheckpointProperties(false, (SnapshotType)CheckpointType.CHECKPOINT, false, false, false, false, false, false);
            CompletedCheckpoint checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(operatorStates), Collections.emptyList(), retainProps, (CompletedCheckpointStorageLocation)retainedLocation, null);
            checkpoint.markAsDiscardedOnShutdown(status).discard();
            ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)0))).discardState();
            Assert.assertFalse((boolean)retainedLocation.isDisposed());
            Assert.assertFalse((boolean)retainedHandle.isDisposed());
            EmptyStreamStateHandle discardHandle = new EmptyStreamStateHandle();
            TestCompletedCheckpointStorageLocation discardLocation = new TestCompletedCheckpointStorageLocation(discardHandle, "ptr");
            CheckpointProperties discardProps = new CheckpointProperties(false, (SnapshotType)CheckpointType.CHECKPOINT, true, true, true, true, true, false);
            checkpoint = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, new HashMap(operatorStates), Collections.emptyList(), discardProps, (CompletedCheckpointStorageLocation)discardLocation, null);
            checkpoint.markAsDiscardedOnShutdown(status).discard();
            ((OperatorState)Mockito.verify((Object)state, (VerificationMode)Mockito.times((int)1))).discardState();
            Assert.assertTrue((boolean)discardLocation.isDisposed());
            Assert.assertTrue((boolean)discardHandle.isDisposed());
        }
    }

    @Test
    public void testCompletedCheckpointStatsCallbacks() throws Exception {
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        JobVertexID jobVertexId = new JobVertexID();
        taskStats.put(jobVertexId, new TaskStateStats(jobVertexId, 1));
        CompletedCheckpointStats checkpointStats = new CompletedCheckpointStats(1L, 0L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1, taskStats, 1, 1L, 1L, 1L, (SubtaskStateStats)Mockito.mock(SubtaskStateStats.class), null);
        CompletedCheckpoint completed = new CompletedCheckpoint(new JobID(), 0L, 0L, 1L, Collections.emptyMap(), Collections.emptyList(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), (CompletedCheckpointStorageLocation)new TestCompletedCheckpointStorageLocation(), checkpointStats);
        completed.markAsDiscardedOnShutdown(JobStatus.FINISHED).discard();
        Assert.assertTrue((boolean)checkpointStats.isDiscarded());
    }

    @Test
    public void testIsJavaSerializable() throws Exception {
        TaskStateStats task1 = new TaskStateStats(new JobVertexID(), 3);
        TaskStateStats task2 = new TaskStateStats(new JobVertexID(), 4);
        HashMap<JobVertexID, TaskStateStats> taskStats = new HashMap<JobVertexID, TaskStateStats>();
        taskStats.put(task1.getJobVertexId(), task1);
        taskStats.put(task2.getJobVertexId(), task2);
        CompletedCheckpointStats completed = new CompletedCheckpointStats(123123123L, 10123L, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), 1337, taskStats, 1337, 123129837912L, 42L, 44L, new SubtaskStateStats(123, 213123L, 123123L, 123123L, 0L, 0L, 0L, 0L, 0L, 0L, false, true), null);
        CompletedCheckpointStats copy = (CompletedCheckpointStats)CommonTestUtils.createCopySerializable((Serializable)completed);
        Assert.assertEquals((long)completed.getCheckpointId(), (long)copy.getCheckpointId());
        Assert.assertEquals((long)completed.getTriggerTimestamp(), (long)copy.getTriggerTimestamp());
        Assert.assertEquals((Object)completed.getProperties(), (Object)copy.getProperties());
        Assert.assertEquals((long)completed.getNumberOfSubtasks(), (long)copy.getNumberOfSubtasks());
        Assert.assertEquals((long)completed.getNumberOfAcknowledgedSubtasks(), (long)copy.getNumberOfAcknowledgedSubtasks());
        Assert.assertEquals((long)completed.getEndToEndDuration(), (long)copy.getEndToEndDuration());
        Assert.assertEquals((long)completed.getStateSize(), (long)copy.getStateSize());
        Assert.assertEquals((long)completed.getProcessedData(), (long)copy.getProcessedData());
        Assert.assertEquals((long)completed.getPersistedData(), (long)copy.getPersistedData());
        Assert.assertEquals((long)completed.getLatestAcknowledgedSubtaskStats().getSubtaskIndex(), (long)copy.getLatestAcknowledgedSubtaskStats().getSubtaskIndex());
        Assert.assertEquals((Object)completed.getStatus(), (Object)copy.getStatus());
    }
}

