/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingExecutionGraphCache
implements ExecutionGraphCache {
    private final IntSupplier sizeSupplier;
    private final BiFunction<JobID, RestfulGateway, CompletableFuture<ExecutionGraphInfo>> getExecutionGraphFunction;
    private final Runnable cleanupRunnable;
    private final Runnable closeRunnable;

    private TestingExecutionGraphCache(IntSupplier sizeSupplier, BiFunction<JobID, RestfulGateway, CompletableFuture<ExecutionGraphInfo>> getExecutionGraphFunction, Runnable cleanupRunnable, Runnable closeRunnable) {
        this.sizeSupplier = sizeSupplier;
        this.getExecutionGraphFunction = getExecutionGraphFunction;
        this.cleanupRunnable = cleanupRunnable;
        this.closeRunnable = closeRunnable;
    }

    public int size() {
        return this.sizeSupplier.getAsInt();
    }

    public CompletableFuture<ExecutionGraphInfo> getExecutionGraphInfo(JobID jobId, RestfulGateway restfulGateway) {
        return this.getExecutionGraphFunction.apply(jobId, restfulGateway);
    }

    public void cleanup() {
        this.cleanupRunnable.run();
    }

    public void close() {
        this.closeRunnable.run();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private IntSupplier sizeSupplier = () -> 0;
        private BiFunction<JobID, RestfulGateway, CompletableFuture<ExecutionGraphInfo>> getExecutionGraphFunction = (ignoredA, ignoredB) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
        private Runnable cleanupRunnable = () -> {};
        private Runnable closeRunnable = () -> {};

        private Builder() {
        }

        public Builder setSizeSupplier(IntSupplier sizeSupplier) {
            this.sizeSupplier = sizeSupplier;
            return this;
        }

        public Builder setGetExecutionGraphFunction(BiFunction<JobID, RestfulGateway, CompletableFuture<ExecutionGraphInfo>> getExecutionGraphFunction) {
            this.getExecutionGraphFunction = getExecutionGraphFunction;
            return this;
        }

        public Builder setCleanupRunnable(Runnable cleanupRunnable) {
            this.cleanupRunnable = cleanupRunnable;
            return this;
        }

        public Builder setCloseRunnable(Runnable closeRunnable) {
            this.closeRunnable = closeRunnable;
            return this;
        }

        public TestingExecutionGraphCache build() {
            return new TestingExecutionGraphCache(this.sizeSupplier, this.getExecutionGraphFunction, this.cleanupRunnable, this.closeRunnable);
        }
    }
}

