/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.LogicalScopeProvider;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.MetricReporterFactory;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class InMemoryReporter
implements MetricReporter {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryReporter.class);
    private static final String ID = "ID";
    private static final Map<UUID, InMemoryReporter> REPORTERS = new ConcurrentHashMap<UUID, InMemoryReporter>();
    private final Map<MetricGroup, Map<String, Metric>> metrics = new HashMap<MetricGroup, Map<String, Metric>>();
    private final UUID id;
    private final boolean retainMetrics;

    InMemoryReporter(boolean retainMetrics) {
        this.retainMetrics = retainMetrics;
        this.id = UUID.randomUUID();
        REPORTERS.put(this.id, this);
    }

    public static InMemoryReporter create() {
        return new InMemoryReporter(false);
    }

    public static InMemoryReporter createWithRetainedMetrics() {
        return new InMemoryReporter(true);
    }

    public void open(MetricConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            this.metrics.clear();
            REPORTERS.remove(this.id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Metric> getMetricsByIdentifiers(JobID jobId) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getMetricStream(jobId).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<MetricGroup, Map<String, Metric>> getMetricsByGroup() {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashMap((Map)e.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Metric> getMetricsByGroup(MetricGroup metricGroup) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return new HashMap<String, Metric>(this.metrics.getOrDefault(metricGroup, Collections.emptyMap()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Metric> findMetrics(JobID jobId, String identifierPattern) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getMetricStream(jobId, identifierPattern).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Metric> findMetric(JobID jobId, String patternString) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getMetricStream(jobId, patternString).map(Map.Entry::getValue).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MetricGroup> findGroups(String groupPattern) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getGroupStream(groupPattern).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<MetricGroup> findGroup(String groupPattern) {
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.getGroupStream(groupPattern).findFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OperatorMetricGroup> findOperatorMetricGroups(JobID jobId, String operatorPattern) {
        Pattern pattern = Pattern.compile(operatorPattern);
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            return this.metrics.keySet().stream().filter(g -> g instanceof OperatorMetricGroup && pattern.matcher(this.getOperatorName((MetricGroup)g)).find() && this.getJobId((MetricGroup)g).equals(jobId.toString())).map(OperatorMetricGroup.class::cast).sorted(Comparator.comparing(this::getSubtaskId)).collect(Collectors.toList());
        }
    }

    private String getSubtaskId(OperatorMetricGroup g) {
        return (String)g.getAllVariables().get(ScopeFormat.SCOPE_TASK_SUBTASK_INDEX);
    }

    private String getOperatorName(MetricGroup g) {
        return (String)g.getAllVariables().get(ScopeFormat.SCOPE_OPERATOR_NAME);
    }

    private String getJobId(MetricGroup g) {
        return (String)g.getAllVariables().get(ScopeFormat.SCOPE_JOB_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        MetricGroup metricGroup = this.unwrap(group);
        LOG.debug("Registered {} @ {}", (Object)metricName, (Object)metricGroup);
        InMemoryReporter inMemoryReporter = this;
        synchronized (inMemoryReporter) {
            this.metrics.computeIfAbsent(metricGroup, dummy -> new HashMap()).put(metricName, metric);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        if (!this.retainMetrics) {
            InMemoryReporter inMemoryReporter = this;
            synchronized (inMemoryReporter) {
                MetricGroup metricGroup = this.unwrap(group);
                Map<String, Metric> registeredMetrics = this.metrics.get(metricGroup);
                if (registeredMetrics != null) {
                    registeredMetrics.remove(metricName);
                    if (registeredMetrics.isEmpty()) {
                        this.metrics.remove(metricGroup);
                    }
                }
            }
        }
    }

    private Stream<Map.Entry<String, Metric>> getMetricStream(JobID jobID, String identifierPattern) {
        Pattern pattern = Pattern.compile(identifierPattern);
        return this.getMetricStream(jobID).filter(m -> pattern.matcher((CharSequence)m.getKey()).find());
    }

    private Stream<Map.Entry<String, Metric>> getMetricStream(JobID jobId) {
        return this.metrics.entrySet().stream().filter(gr -> Objects.equals(this.getJobId((MetricGroup)gr.getKey()), jobId.toString())).flatMap(this::getGroupMetricStream);
    }

    private Stream<MetricGroup> getGroupStream(String groupPattern) {
        Pattern pattern = Pattern.compile(groupPattern);
        return this.metrics.keySet().stream().filter(group -> Arrays.stream(group.getScopeComponents()).anyMatch(scope -> pattern.matcher((CharSequence)scope).find()));
    }

    private Stream<AbstractMap.SimpleEntry<String, Metric>> getGroupMetricStream(Map.Entry<MetricGroup, Map<String, Metric>> groupMetrics) {
        return groupMetrics.getValue().entrySet().stream().map(nameMetric -> new AbstractMap.SimpleEntry(((MetricGroup)groupMetrics.getKey()).getMetricIdentifier((String)nameMetric.getKey()), nameMetric.getValue()));
    }

    private MetricGroup unwrap(MetricGroup group) {
        return group instanceof LogicalScopeProvider ? ((LogicalScopeProvider)group).getWrappedMetricGroup() : group;
    }

    public Configuration addToConfiguration(Configuration configuration) {
        configuration.setString("metrics.reporter.mini_cluster_resource_reporter." + MetricOptions.REPORTER_FACTORY_CLASS.key(), Factory.class.getName());
        configuration.setString("metrics.reporter.mini_cluster_resource_reporter.ID", this.id.toString());
        return configuration;
    }

    public static class Factory
    implements MetricReporterFactory {
        public MetricReporter createMetricReporter(Properties properties) {
            String id = properties.getProperty(InMemoryReporter.ID);
            Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)"Reporter id not found. Did you use InMemoryReporter#addConfiguration?");
            return (MetricReporter)REPORTERS.get(UUID.fromString(id));
        }
    }
}

