/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.runtime.state.JavaSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JavaSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Serializable, Serializable> {
    private static final String SPEC_NAME = "java-serializer";

    public JavaSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<Serializable, Serializable> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, JavaSerializerSetup.class, JavaSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class JavaSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<Serializable> {
        public TypeSerializer<Serializable> createUpgradedSerializer() {
            return new JavaSerializer();
        }

        public Matcher<Serializable> testDataMatcher() {
            return Matchers.is((Object)26);
        }

        public Matcher<TypeSerializerSchemaCompatibility<Serializable>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class JavaSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<Serializable> {
        public TypeSerializer<Serializable> createPriorSerializer() {
            return new JavaSerializer();
        }

        public Serializable createTestData() {
            return Integer.valueOf(26);
        }
    }
}

