/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.runtime.state.ArrayListSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArrayListSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<ArrayList<String>, ArrayList<String>> {
    private static final String SPEC_NAME = "arraylist-serializer";

    public ArrayListSerializerUpgradeTest(TypeSerializerUpgradeTestBase.TestSpecification<ArrayList<String>, ArrayList<String>> testSpecification) {
        super(testSpecification);
    }

    @Parameterized.Parameters(name="Test Specification = {0}")
    public static Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> testSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, ArrayListSerializerSetup.class, ArrayListSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class ArrayListSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<ArrayList<String>> {
        public TypeSerializer<ArrayList<String>> createUpgradedSerializer() {
            return new ArrayListSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public Matcher<ArrayList<String>> testDataMatcher() {
            ArrayList<String> data = new ArrayList<String>(2);
            data.add("Apache");
            data.add("Flink");
            return Matchers.is(data);
        }

        public Matcher<TypeSerializerSchemaCompatibility<ArrayList<String>>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class ArrayListSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<ArrayList<String>> {
        public TypeSerializer<ArrayList<String>> createPriorSerializer() {
            return new ArrayListSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        public ArrayList<String> createTestData() {
            ArrayList<String> data = new ArrayList<String>(2);
            data.add("Apache");
            data.add("Flink");
            return data;
        }
    }
}

