/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.token;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.testutils.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.security.token.ExceptionThrowingDelegationTokenProvider;
import org.apache.flink.runtime.security.token.KerberosDelegationTokenManager;
import org.apache.flink.runtime.security.token.KerberosLoginProvider;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class KerberosDelegationTokenManagerITCase {
    @Test
    public void isProviderEnabledMustGiveBackTrueByDefault() {
        ExceptionThrowingDelegationTokenProvider.enabled = false;
        Configuration configuration = new Configuration();
        KerberosDelegationTokenManager delegationTokenManager = new KerberosDelegationTokenManager(configuration, null, null);
        Assertions.assertTrue((boolean)delegationTokenManager.isProviderEnabled("test"));
    }

    @Test
    public void isProviderEnabledMustGiveBackFalseWhenDisabled() {
        ExceptionThrowingDelegationTokenProvider.enabled = false;
        Configuration configuration = new Configuration();
        configuration.setBoolean("security.kerberos.token.provider.test.enabled", false);
        KerberosDelegationTokenManager delegationTokenManager = new KerberosDelegationTokenManager(configuration, null, null);
        Assertions.assertFalse((boolean)delegationTokenManager.isProviderEnabled("test"));
    }

    @Test
    public void configurationIsNullMustFailFast() {
        Assertions.assertThrows(Exception.class, () -> new KerberosDelegationTokenManager(null, null, null));
    }

    @Test
    public void oneProviderThrowsExceptionMustFailFast() {
        Assertions.assertThrows(Exception.class, () -> {
            try {
                ExceptionThrowingDelegationTokenProvider.enabled = true;
                new KerberosDelegationTokenManager(new Configuration(), null, null);
            }
            finally {
                ExceptionThrowingDelegationTokenProvider.enabled = false;
            }
        });
    }

    @Test
    public void testAllProvidersLoaded() {
        ExceptionThrowingDelegationTokenProvider.enabled = false;
        ExceptionThrowingDelegationTokenProvider.constructed = false;
        Configuration configuration = new Configuration();
        configuration.setBoolean("security.kerberos.token.provider.throw.enabled", false);
        KerberosDelegationTokenManager delegationTokenManager = new KerberosDelegationTokenManager(configuration, null, null);
        Assertions.assertEquals((int)2, (int)delegationTokenManager.delegationTokenProviders.size());
        Assertions.assertTrue((boolean)delegationTokenManager.isProviderLoaded("hadoopfs"));
        Assertions.assertTrue((boolean)delegationTokenManager.isProviderLoaded("test"));
        Assertions.assertTrue((boolean)ExceptionThrowingDelegationTokenProvider.constructed);
        Assertions.assertFalse((boolean)delegationTokenManager.isProviderLoaded("throw"));
    }

    @Test
    public void startTGTRenewalShouldScheduleRenewal() throws IOException {
        ManuallyTriggeredScheduledExecutor scheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            Mockito.when((Object)userGroupInformation.isFromKeytab()).thenReturn((Object)true);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            ExceptionThrowingDelegationTokenProvider.enabled = false;
            ExceptionThrowingDelegationTokenProvider.constructed = false;
            Configuration configuration = new Configuration();
            configuration.setBoolean("security.kerberos.token.provider.throw.enabled", false);
            KerberosDelegationTokenManager delegationTokenManager = new KerberosDelegationTokenManager(configuration, (ScheduledExecutor)scheduledExecutor, (ExecutorService)scheduler);
            delegationTokenManager.startTGTRenewal();
            scheduledExecutor.triggerPeriodicScheduledTasks();
            scheduler.triggerAll();
            delegationTokenManager.stopTGTRenewal();
            ((UserGroupInformation)Mockito.verify((Object)userGroupInformation, (VerificationMode)Mockito.times((int)1))).checkTGTAndReloginFromKeytab();
        }
    }

    @Test
    public void startTokensUpdateShouldScheduleRenewal() throws IOException {
        ManuallyTriggeredScheduledExecutor scheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        try (MockedStatic ugi = Mockito.mockStatic(UserGroupInformation.class);){
            final UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
            ugi.when(UserGroupInformation::getCurrentUser).thenReturn((Object)userGroupInformation);
            ExceptionThrowingDelegationTokenProvider.enabled = false;
            ExceptionThrowingDelegationTokenProvider.constructed = false;
            Configuration configuration = new Configuration();
            configuration.setBoolean("security.kerberos.token.provider.throw.enabled", false);
            final AtomicInteger startTokensUpdateCallCount = new AtomicInteger(0);
            final AtomicBoolean retryExceptionThrown = new AtomicBoolean(false);
            KerberosLoginProvider kerberosLoginProvider = new KerberosLoginProvider(configuration){

                public UserGroupInformation doLogin() {
                    if (startTokensUpdateCallCount.get() == 2) {
                        retryExceptionThrown.set(true);
                        throw new RuntimeException("Intended exception to test retry");
                    }
                    return userGroupInformation;
                }
            };
            KerberosDelegationTokenManager delegationTokenManager = new KerberosDelegationTokenManager(configuration, (ScheduledExecutor)scheduledExecutor, (ExecutorService)scheduler, kerberosLoginProvider){

                void startTokensUpdate() {
                    startTokensUpdateCallCount.incrementAndGet();
                    super.startTokensUpdate();
                }
            };
            delegationTokenManager.startTokensUpdate();
            scheduledExecutor.triggerScheduledTasks();
            scheduler.triggerAll();
            scheduledExecutor.triggerScheduledTasks();
            scheduler.triggerAll();
            delegationTokenManager.stopTokensUpdate();
            Assertions.assertTrue((boolean)retryExceptionThrown.get());
            Assertions.assertEquals((int)3, (int)startTokensUpdateCallCount.get());
        }
    }

    @Test
    public void calculateRenewalDelayShouldConsiderRenewalRatio() {
        ExceptionThrowingDelegationTokenProvider.enabled = false;
        ExceptionThrowingDelegationTokenProvider.constructed = false;
        Configuration configuration = new Configuration();
        configuration.setBoolean("security.kerberos.token.provider.throw.enabled", false);
        configuration.set(SecurityOptions.KERBEROS_TOKENS_RENEWAL_TIME_RATIO, (Object)0.5);
        KerberosDelegationTokenManager delegationTokenManager = new KerberosDelegationTokenManager(configuration, null, null);
        Clock constantClock = Clock.fixed(Instant.ofEpochMilli(100L), ZoneId.systemDefault());
        Assertions.assertEquals((long)50L, (long)delegationTokenManager.calculateRenewalDelay(constantClock, 200L));
    }
}

