/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SharedSlotTestingUtils;
import org.apache.flink.runtime.scheduler.SharingPhysicalSlotRequestBulk;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SharingPhysicalSlotRequestBulkTest
extends TestLogger {
    private static final ExecutionVertexID EV1 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV2 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV3 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV4 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV5 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionSlotSharingGroup SG1 = SharedSlotTestingUtils.createExecutionSlotSharingGroup(EV1, EV2, EV3);
    private static final ExecutionSlotSharingGroup SG2 = SharedSlotTestingUtils.createExecutionSlotSharingGroup(EV4, EV5);
    private static final ResourceProfile RP1 = ResourceProfile.newBuilder().setCpuCores(3.0).build();
    private static final ResourceProfile RP2 = ResourceProfile.newBuilder().setCpuCores(2.0).build();

    @Test
    public void testCreation() {
        SharingPhysicalSlotRequestBulk bulk = SharingPhysicalSlotRequestBulkTest.createBulk();
        Assert.assertThat((Object)bulk.getPendingRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])new ResourceProfile[]{RP1, RP2}));
        Assert.assertThat((Object)bulk.getAllocationIdsOfFulfilledRequests(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void testMarkFulfilled() {
        SharingPhysicalSlotRequestBulk bulk = SharingPhysicalSlotRequestBulkTest.createBulk();
        AllocationID allocationId = new AllocationID();
        bulk.markFulfilled(SG1, allocationId);
        Assert.assertThat((Object)bulk.getPendingRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])new ResourceProfile[]{RP2}));
        Assert.assertThat((Object)bulk.getAllocationIdsOfFulfilledRequests(), (Matcher)Matchers.containsInAnyOrder((Object[])new AllocationID[]{allocationId}));
    }

    @Test
    public void testCancel() {
        LogicalSlotRequestCanceller canceller = new LogicalSlotRequestCanceller();
        SharingPhysicalSlotRequestBulk bulk = SharingPhysicalSlotRequestBulkTest.createBulk(canceller);
        bulk.markFulfilled(SG1, new AllocationID());
        Throwable cause = new Throwable();
        bulk.cancel(cause);
        Assert.assertThat((Object)canceller.cancellations, (Matcher)Matchers.containsInAnyOrder((Object[])new Tuple2[]{Tuple2.of((Object)EV1, (Object)cause), Tuple2.of((Object)EV2, (Object)cause), Tuple2.of((Object)EV4, (Object)cause)}));
    }

    @Test
    public void testClearPendingRequests() {
        SharingPhysicalSlotRequestBulk bulk = SharingPhysicalSlotRequestBulkTest.createBulk();
        bulk.clearPendingRequests();
        Assert.assertThat((Object)bulk.getPendingRequests(), (Matcher)Matchers.hasSize((int)0));
    }

    private static SharingPhysicalSlotRequestBulk createBulk() {
        return SharingPhysicalSlotRequestBulkTest.createBulk((executionVertexID, throwable) -> {});
    }

    private static SharingPhysicalSlotRequestBulk createBulk(BiConsumer<ExecutionVertexID, Throwable> canceller) {
        IdentityHashMap<ExecutionSlotSharingGroup, ResourceProfile> pendingRequests = new IdentityHashMap<ExecutionSlotSharingGroup, ResourceProfile>();
        pendingRequests.put(SG1, RP1);
        pendingRequests.put(SG2, RP2);
        HashMap<ExecutionSlotSharingGroup, List<ExecutionVertexID>> executions = new HashMap<ExecutionSlotSharingGroup, List<ExecutionVertexID>>();
        executions.put(SG1, Arrays.asList(EV1, EV2));
        executions.put(SG2, Collections.singletonList(EV4));
        return new SharingPhysicalSlotRequestBulk(executions, pendingRequests, canceller);
    }

    private static class LogicalSlotRequestCanceller
    implements BiConsumer<ExecutionVertexID, Throwable> {
        private final List<Tuple2<ExecutionVertexID, Throwable>> cancellations = new ArrayList<Tuple2<ExecutionVertexID, Throwable>>();

        private LogicalSlotRequestCanceller() {
        }

        @Override
        public void accept(ExecutionVertexID executionVertexID, Throwable throwable) {
            this.cancellations.add((Tuple2<ExecutionVertexID, Throwable>)Tuple2.of((Object)executionVertexID, (Object)throwable));
        }
    }
}

