/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingJobsMetricsHandler;
import org.apache.flink.runtime.rest.handler.job.metrics.AggregatingMetricsHandlerTestBase;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.messages.job.metrics.AggregatedJobMetricsParameters;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class AggregatingJobsMetricsHandlerTest
extends AggregatingMetricsHandlerTestBase<AggregatingJobsMetricsHandler, AggregatedJobMetricsParameters> {
    private static final JobID JOB_ID_1 = JobID.generate();
    private static final JobID JOB_ID_2 = JobID.generate();
    private static final JobID JOB_ID_3 = JobID.generate();

    @Override
    protected Tuple2<String, List<String>> getFilter() {
        return Tuple2.of((Object)"jobs", Arrays.asList(JOB_ID_1.toString(), JOB_ID_3.toString()));
    }

    @Override
    protected Collection<MetricDump> getMetricDumps() {
        ArrayList<MetricDump> dumps = new ArrayList<MetricDump>(3);
        QueryScopeInfo.JobQueryScopeInfo job = new QueryScopeInfo.JobQueryScopeInfo(JOB_ID_1.toString(), "abc");
        MetricDump.CounterDump cd1 = new MetricDump.CounterDump((QueryScopeInfo)job, "metric1", 1L);
        dumps.add((MetricDump)cd1);
        QueryScopeInfo.JobQueryScopeInfo job2 = new QueryScopeInfo.JobQueryScopeInfo(JOB_ID_2.toString(), "abc");
        MetricDump.CounterDump cd2 = new MetricDump.CounterDump((QueryScopeInfo)job2, "metric1", 3L);
        dumps.add((MetricDump)cd2);
        QueryScopeInfo.JobQueryScopeInfo job3 = new QueryScopeInfo.JobQueryScopeInfo(JOB_ID_3.toString(), "abc");
        MetricDump.CounterDump cd3 = new MetricDump.CounterDump((QueryScopeInfo)job3, "metric2", 5L);
        dumps.add((MetricDump)cd3);
        return dumps;
    }

    @Override
    protected AggregatingJobsMetricsHandler getHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, Executor executor, MetricFetcher fetcher) {
        return new AggregatingJobsMetricsHandler(leaderRetriever, timeout, responseHeaders, executor, fetcher);
    }
}

