/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.minicluster.TestingMiniClusterConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.security.token.DelegationTokenManager;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestingMiniCluster
extends MiniCluster {
    private final int numberDispatcherResourceManagerComponents;
    private final boolean localCommunication;
    @Nullable
    private final Supplier<HighAvailabilityServices> highAvailabilityServicesSupplier;
    @Nullable
    private final Supplier<DispatcherResourceManagerComponentFactory> dispatcherResourceManagerComponentFactorySupplier;

    public static Builder newBuilder(TestingMiniClusterConfiguration configuration) {
        return new Builder(configuration);
    }

    private TestingMiniCluster(TestingMiniClusterConfiguration miniClusterConfiguration, @Nullable Supplier<HighAvailabilityServices> highAvailabilityServicesSupplier, @Nullable Supplier<DispatcherResourceManagerComponentFactory> dispatcherResourceManagerComponentFactorySupplier) {
        super((MiniClusterConfiguration)miniClusterConfiguration);
        this.numberDispatcherResourceManagerComponents = miniClusterConfiguration.getNumberDispatcherResourceManagerComponents();
        this.highAvailabilityServicesSupplier = highAvailabilityServicesSupplier;
        this.dispatcherResourceManagerComponentFactorySupplier = dispatcherResourceManagerComponentFactorySupplier;
        this.localCommunication = miniClusterConfiguration.isLocalCommunication();
    }

    protected boolean useLocalCommunication() {
        return this.localCommunication;
    }

    protected HighAvailabilityServices createHighAvailabilityServices(Configuration configuration, Executor executor) throws Exception {
        if (this.highAvailabilityServicesSupplier != null) {
            return this.highAvailabilityServicesSupplier.get();
        }
        return super.createHighAvailabilityServices(configuration, executor);
    }

    protected DispatcherResourceManagerComponentFactory createDispatcherResourceManagerComponentFactory() {
        if (this.dispatcherResourceManagerComponentFactorySupplier != null) {
            return this.dispatcherResourceManagerComponentFactorySupplier.get();
        }
        return super.createDispatcherResourceManagerComponentFactory();
    }

    protected Collection<? extends DispatcherResourceManagerComponent> createDispatcherResourceManagerComponents(Configuration configuration, MiniCluster.RpcServiceFactory rpcServiceFactory, BlobServer blobServer, HeartbeatServices heartbeatServices, DelegationTokenManager delegationTokenManager, MetricRegistry metricRegistry, MetricQueryServiceRetriever metricQueryServiceRetriever, FatalErrorHandler fatalErrorHandler) throws Exception {
        DispatcherResourceManagerComponentFactory dispatcherResourceManagerComponentFactory = this.createDispatcherResourceManagerComponentFactory();
        ArrayList<DispatcherResourceManagerComponent> result = new ArrayList<DispatcherResourceManagerComponent>(this.numberDispatcherResourceManagerComponents);
        for (int i = 0; i < this.numberDispatcherResourceManagerComponents; ++i) {
            HighAvailabilityServices thisHaServices = this.createHighAvailabilityServices(configuration, this.getIOExecutor());
            DispatcherResourceManagerComponent dispatcherResourceManagerComponent = dispatcherResourceManagerComponentFactory.create(configuration, ResourceID.generate(), this.getIOExecutor(), rpcServiceFactory.createRpcService(), thisHaServices, blobServer, heartbeatServices, delegationTokenManager, metricRegistry, (ExecutionGraphInfoStore)new MemoryExecutionGraphInfoStore(), metricQueryServiceRetriever, fatalErrorHandler);
            CompletionStage shutDownFuture = ((CompletableFuture)dispatcherResourceManagerComponent.getShutDownFuture().thenCompose(applicationStatus -> dispatcherResourceManagerComponent.stopApplication(applicationStatus, null))).thenRun(() -> {
                try {
                    thisHaServices.close();
                }
                catch (Exception ex) {
                    throw new CompletionException("HighAvailabilityServices were not expected to fail but did", ex);
                }
            });
            FutureUtils.assertNoException((CompletableFuture)shutDownFuture);
            result.add(dispatcherResourceManagerComponent);
        }
        return result;
    }

    public CompletableFuture<DispatcherGateway> getDispatcherGatewayFuture() {
        return super.getDispatcherGatewayFuture();
    }

    public static class Builder {
        private final TestingMiniClusterConfiguration configuration;
        @Nullable
        private Supplier<HighAvailabilityServices> highAvailabilityServicesSupplier;
        @Nullable
        private Supplier<DispatcherResourceManagerComponentFactory> dispatcherResourceManagerComponentFactorySupplier;

        public Builder(TestingMiniClusterConfiguration configuration) {
            this.configuration = configuration;
        }

        public Builder setHighAvailabilityServicesSupplier(@Nullable Supplier<HighAvailabilityServices> highAvailabilityServicesSupplier) {
            this.highAvailabilityServicesSupplier = highAvailabilityServicesSupplier;
            return this;
        }

        public Builder setDispatcherResourceManagerComponentFactorySupplier(@Nullable Supplier<DispatcherResourceManagerComponentFactory> dispatcherResourceManagerComponentFactorySupplier) {
            this.dispatcherResourceManagerComponentFactorySupplier = dispatcherResourceManagerComponentFactorySupplier;
            return this;
        }

        public TestingMiniCluster build() {
            return new TestingMiniCluster(this.configuration, this.highAvailabilityServicesSupplier, this.dispatcherResourceManagerComponentFactorySupplier);
        }
    }
}

