/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkWithTimestamp;
import org.apache.flink.runtime.jobmaster.slotpool.TestingPhysicalSlotRequestBulkBuilder;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.clock.ManualClock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PhysicalSlotRequestBulkWithTimestampTest
extends TestLogger {
    private final ManualClock clock = new ManualClock();

    @Test
    public void testMarkBulkUnfulfillable() {
        PhysicalSlotRequestBulkWithTimestamp bulk = PhysicalSlotRequestBulkWithTimestampTest.createPhysicalSlotRequestBulkWithTimestamp();
        this.clock.advanceTime(456L, TimeUnit.MILLISECONDS);
        bulk.markUnfulfillable(this.clock.relativeTimeMillis());
        Assert.assertThat((Object)bulk.getUnfulfillableSince(), (Matcher)Matchers.is((Object)this.clock.relativeTimeMillis()));
    }

    @Test
    public void testUnfulfillableTimestampWillNotBeOverriddenByFollowingUnfulfillableTimestamp() {
        PhysicalSlotRequestBulkWithTimestamp bulk = PhysicalSlotRequestBulkWithTimestampTest.createPhysicalSlotRequestBulkWithTimestamp();
        long unfulfillableSince = this.clock.relativeTimeMillis();
        bulk.markUnfulfillable(unfulfillableSince);
        this.clock.advanceTime(456L, TimeUnit.MILLISECONDS);
        bulk.markUnfulfillable(this.clock.relativeTimeMillis());
        Assert.assertThat((Object)bulk.getUnfulfillableSince(), (Matcher)Matchers.is((Object)unfulfillableSince));
    }

    private static PhysicalSlotRequestBulkWithTimestamp createPhysicalSlotRequestBulkWithTimestamp() {
        return TestingPhysicalSlotRequestBulkBuilder.newBuilder().buildPhysicalSlotRequestBulkWithTimestamp();
    }
}

