/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.client.JobCancellationException;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class JobResultTest
extends TestLogger {
    @Test
    public void testNetRuntimeMandatory() {
        try {
            new JobResult.Builder().jobId(new JobID()).build();
            Assert.fail((String)"Expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.equalTo((Object)"netRuntime must be greater than or equals 0"));
        }
    }

    @Test
    public void testIsNotSuccess() throws Exception {
        JobResult jobResult = new JobResult.Builder().jobId(new JobID()).serializedThrowable(new SerializedThrowable((Throwable)new RuntimeException())).netRuntime(Long.MAX_VALUE).build();
        Assert.assertThat((Object)jobResult.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testIsSuccess() throws Exception {
        JobResult jobResult = new JobResult.Builder().jobId(new JobID()).netRuntime(Long.MAX_VALUE).build();
        Assert.assertThat((Object)jobResult.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testCancelledJobIsFailureResult() {
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.CANCELED).build());
        Assert.assertThat((Object)jobResult.isSuccess(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testFailedJobIsFailureResult() {
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.FAILED).setFailureCause(new ErrorInfo((Throwable)new FlinkException("Test exception"), 42L)).build());
        Assert.assertThat((Object)jobResult.isSuccess(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testCancelledJobThrowsJobCancellationException() throws Exception {
        FlinkException cause = new FlinkException("Test exception");
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.CANCELED).setFailureCause(new ErrorInfo((Throwable)cause, 42L)).build());
        try {
            jobResult.toJobExecutionResult(((Object)((Object)this)).getClass().getClassLoader());
            Assert.fail((String)"Job should fail with an JobCancellationException.");
        }
        catch (JobCancellationException expected) {
            Assert.assertThat((Object)expected.getCause(), (Matcher)Matchers.is((Matcher)IsNull.nullValue()));
        }
    }

    @Test
    public void testFailedJobThrowsJobExecutionException() throws Exception {
        FlinkException cause = new FlinkException("Test exception");
        JobResult jobResult = JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.FAILED).setFailureCause(new ErrorInfo((Throwable)cause, 42L)).build());
        try {
            jobResult.toJobExecutionResult(((Object)((Object)this)).getClass().getClassLoader());
            Assert.fail((String)"Job should fail with JobExecutionException.");
        }
        catch (JobExecutionException expected) {
            Assert.assertThat((Object)expected.getCause(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)((Object)cause))));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testFailureResultRequiresFailureCause() {
        JobResult.createFrom((AccessExecutionGraph)new ArchivedExecutionGraphBuilder().setJobID(new JobID()).setState(JobStatus.FAILED).build());
    }
}

