/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.util.List;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.FileChannelInputView;
import org.apache.flink.runtime.io.disk.FileChannelOutputView;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.PairGenerator;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileChannelStreamsITCase
extends TestLogger {
    private static final long SEED = 649180756312423613L;
    private static final int KEY_MAX = Integer.MAX_VALUE;
    private static final int VALUE_SHORT_LENGTH = 114;
    private static final int VALUE_LONG_LENGTH = 114688;
    private static final int NUM_PAIRS_SHORT = 1000000;
    private static final int NUM_PAIRS_LONG = 3000;
    private static final int MEMORY_PAGE_SIZE = 32768;
    private static final int NUM_MEMORY_SEGMENTS = 3;
    private IOManager ioManager;
    private MemoryManager memManager;

    @Before
    public void beforeTest() {
        this.memManager = MemoryManagerBuilder.newBuilder().setMemorySize(98304L).setPageSize(32768).build();
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void afterTest() throws Exception {
        this.ioManager.close();
        Assert.assertTrue((String)"The memory has not been properly released", (boolean)this.memManager.verifyEmpty());
    }

    @Test
    public void testWriteReadSmallRecords() {
        try {
            List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
            PairGenerator.Pair pair = new PairGenerator.Pair();
            for (int i = 0; i < 1000000; ++i) {
                generator.next(pair);
                pair.write((DataOutputView)outView);
            }
            outView.close();
            List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
            FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
            generator.reset();
            PairGenerator.Pair readPair = new PairGenerator.Pair();
            for (int i = 0; i < 1000000; ++i) {
                generator.next(pair);
                readPair.read((DataInputView)inView);
                Assert.assertEquals((String)"The re-generated and the read record do not match.", (Object)pair, (Object)readPair);
            }
            inView.close();
            reader.deleteChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWriteAndReadLongRecords() {
        try {
            List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114688, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
            PairGenerator.Pair pair = new PairGenerator.Pair();
            for (int i = 0; i < 3000; ++i) {
                generator.next(pair);
                pair.write((DataOutputView)outView);
            }
            outView.close();
            List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
            FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
            generator.reset();
            PairGenerator.Pair readPair = new PairGenerator.Pair();
            for (int i = 0; i < 3000; ++i) {
                generator.next(pair);
                readPair.read((DataInputView)inView);
                Assert.assertEquals((String)"The re-generated and the read record do not match.", (Object)pair, (Object)readPair);
            }
            inView.close();
            reader.deleteChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testReadTooMany() {
        try {
            List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
            PairGenerator.Pair pair = new PairGenerator.Pair();
            for (int i = 0; i < 1000000; ++i) {
                generator.next(pair);
                pair.write((DataOutputView)outView);
            }
            outView.close();
            List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
            FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
            generator.reset();
            try {
                PairGenerator.Pair readPair = new PairGenerator.Pair();
                for (int i = 0; i < 1000001; ++i) {
                    generator.next(pair);
                    readPair.read((DataInputView)inView);
                    Assert.assertEquals((String)"The re-generated and the read record do not match.", (Object)pair, (Object)readPair);
                }
                Assert.fail((String)"Expected an EOFException which did not occur.");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            inView.close();
            reader.deleteChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWriteReadOneBufferOnly() {
        try {
            List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 1);
            PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
            PairGenerator.Pair pair = new PairGenerator.Pair();
            for (int i = 0; i < 1000000; ++i) {
                generator.next(pair);
                pair.write((DataOutputView)outView);
            }
            outView.close();
            List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 1);
            BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
            FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
            generator.reset();
            PairGenerator.Pair readPair = new PairGenerator.Pair();
            for (int i = 0; i < 1000000; ++i) {
                generator.next(pair);
                readPair.read((DataInputView)inView);
                Assert.assertEquals((String)"The re-generated and the read record do not match.", (Object)pair, (Object)readPair);
            }
            inView.close();
            reader.deleteChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWriteReadNotAll() {
        try {
            List memory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            PairGenerator generator = new PairGenerator(649180756312423613L, Integer.MAX_VALUE, 114, PairGenerator.KeyMode.RANDOM, PairGenerator.ValueMode.RANDOM_LENGTH);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BlockChannelWriter writer = this.ioManager.createBlockChannelWriter(channel);
            FileChannelOutputView outView = new FileChannelOutputView(writer, this.memManager, memory, 32768);
            PairGenerator.Pair pair = new PairGenerator.Pair();
            for (int i = 0; i < 1000000; ++i) {
                generator.next(pair);
                pair.write((DataOutputView)outView);
            }
            outView.close();
            List readMemory = this.memManager.allocatePages((Object)new DummyInvokable(), 3);
            BlockChannelReader reader = this.ioManager.createBlockChannelReader(channel);
            FileChannelInputView inView = new FileChannelInputView(reader, this.memManager, readMemory, outView.getBytesInLatestSegment());
            generator.reset();
            PairGenerator.Pair readPair = new PairGenerator.Pair();
            for (int i = 0; i < 500000; ++i) {
                generator.next(pair);
                readPair.read((DataInputView)inView);
                Assert.assertEquals((String)"The re-generated and the read record do not match.", (Object)pair, (Object)readPair);
            }
            inView.close();
            reader.deleteChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

