/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class BatchShuffleReadBufferPoolTest {
    @Rule
    public Timeout timeout = new Timeout(60L, TimeUnit.SECONDS);

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalTotalBytes() {
        this.createBufferPool(0L, 1024);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalBufferSize() {
        this.createBufferPool(0x2000000L, 0);
    }

    @Test
    public void testLargeTotalBytes() {
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool(Long.MAX_VALUE, 1024);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)bufferPool.getNumTotalBuffers());
        bufferPool.destroy();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTotalBytesSmallerThanBufferSize() {
        this.createBufferPool(4096L, 32768);
    }

    @Test
    public void testBufferCalculation() {
        long totalBytes = 0x2000000L;
        int bufferSize = 4096;
        while ((long)bufferSize <= totalBytes) {
            BatchShuffleReadBufferPool bufferPool = this.createBufferPool(totalBytes, bufferSize);
            Assert.assertEquals((long)totalBytes, (long)bufferPool.getTotalBytes());
            Assert.assertEquals((long)(totalBytes / (long)bufferSize), (long)bufferPool.getNumTotalBuffers());
            Assert.assertTrue((bufferPool.getNumBuffersPerRequest() <= bufferPool.getNumTotalBuffers() ? 1 : 0) != 0);
            Assert.assertTrue((bufferPool.getNumBuffersPerRequest() > 0 ? 1 : 0) != 0);
            bufferSize += 1024;
        }
    }

    @Test
    public void testRequestBuffers() throws Exception {
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        ArrayList buffers = new ArrayList();
        try {
            buffers.addAll(bufferPool.requestBuffers());
            Assert.assertEquals((long)bufferPool.getNumBuffersPerRequest(), (long)buffers.size());
        }
        finally {
            bufferPool.recycle(buffers);
            bufferPool.destroy();
        }
    }

    @Test
    public void testRecycle() throws Exception {
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        List buffers = bufferPool.requestBuffers();
        bufferPool.recycle((Collection)buffers);
        Assert.assertEquals((long)bufferPool.getNumTotalBuffers(), (long)bufferPool.getAvailableBuffers());
    }

    @Test
    public void testBufferOperationTimestampUpdated() throws Exception {
        BatchShuffleReadBufferPool bufferPool = new BatchShuffleReadBufferPool(1024L, 1024);
        long oldTimestamp = bufferPool.getLastBufferOperationTimestamp();
        Thread.sleep(100L);
        List buffers = bufferPool.requestBuffers();
        Assert.assertEquals((long)1L, (long)buffers.size());
        Assert.assertTrue((bufferPool.getLastBufferOperationTimestamp() > oldTimestamp ? 1 : 0) != 0);
        oldTimestamp = bufferPool.getLastBufferOperationTimestamp();
        Thread.sleep(100L);
        bufferPool.recycle((Collection)buffers);
        Assert.assertTrue((bufferPool.getLastBufferOperationTimestamp() > oldTimestamp ? 1 : 0) != 0);
        buffers = bufferPool.requestBuffers();
        oldTimestamp = bufferPool.getLastBufferOperationTimestamp();
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)bufferPool.requestBuffers().size());
        Assert.assertEquals((long)oldTimestamp, (long)bufferPool.getLastBufferOperationTimestamp());
        bufferPool.recycle((Collection)buffers);
        bufferPool.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBufferFulfilledByRecycledBuffers() throws Exception {
        int numRequestThreads = 2;
        AtomicReference exception = new AtomicReference();
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        ConcurrentHashMap<Object, List> buffers = new ConcurrentHashMap<Object, List>();
        try {
            Object[] owners = new Object[8];
            for (int i = 0; i < 8; ++i) {
                owners[i] = new Object();
                buffers.put(owners[i], bufferPool.requestBuffers());
            }
            Assert.assertEquals((long)0L, (long)bufferPool.getAvailableBuffers());
            Thread[] requestThreads = new Thread[numRequestThreads];
            for (int i = 0; i < numRequestThreads; ++i) {
                requestThreads[i] = new Thread(() -> {
                    try {
                        Object owner = new Object();
                        List allocated = null;
                        while (allocated == null || allocated.isEmpty()) {
                            allocated = bufferPool.requestBuffers();
                        }
                        buffers.put(owner, allocated);
                    }
                    catch (Throwable throwable) {
                        exception.set(throwable);
                    }
                });
                requestThreads[i].start();
            }
            for (MemorySegment segment : (List)buffers.remove(owners[0])) {
                bufferPool.recycle(segment);
            }
            bufferPool.recycle((Collection)buffers.remove(owners[1]));
            for (Thread requestThread : requestThreads) {
                requestThread.join();
            }
            Assert.assertNull(exception.get());
            Assert.assertEquals((long)0L, (long)bufferPool.getAvailableBuffers());
            Assert.assertEquals((long)8L, (long)buffers.size());
        }
        finally {
            for (Object owner : buffers.keySet()) {
                bufferPool.recycle((Collection)buffers.remove(owner));
            }
            Assert.assertEquals((long)bufferPool.getNumTotalBuffers(), (long)bufferPool.getAvailableBuffers());
            bufferPool.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleThreadRequestAndRecycle() throws Exception {
        int numRequestThreads = 10;
        AtomicReference exception = new AtomicReference();
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        try {
            Thread[] requestThreads = new Thread[numRequestThreads];
            for (int i = 0; i < numRequestThreads; ++i) {
                requestThreads[i] = new Thread(() -> {
                    try {
                        for (int j = 0; j < 100; ++j) {
                            List buffers = bufferPool.requestBuffers();
                            Thread.sleep(10L);
                            if (j % 2 == 0) {
                                bufferPool.recycle((Collection)buffers);
                                continue;
                            }
                            for (MemorySegment segment : buffers) {
                                bufferPool.recycle(segment);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        exception.set(throwable);
                    }
                });
                requestThreads[i].start();
            }
            for (Thread requestThread : requestThreads) {
                requestThread.join();
            }
            Assert.assertNull(exception.get());
            Assert.assertEquals((long)bufferPool.getNumTotalBuffers(), (long)bufferPool.getAvailableBuffers());
        }
        finally {
            bufferPool.destroy();
        }
    }

    @Test
    public void testDestroy() throws Exception {
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        List buffers = bufferPool.requestBuffers();
        bufferPool.recycle((Collection)buffers);
        Assert.assertFalse((boolean)bufferPool.isDestroyed());
        Assert.assertEquals((long)bufferPool.getNumTotalBuffers(), (long)bufferPool.getAvailableBuffers());
        buffers = bufferPool.requestBuffers();
        Assert.assertEquals((long)(bufferPool.getNumTotalBuffers() - buffers.size()), (long)bufferPool.getAvailableBuffers());
        bufferPool.destroy();
        Assert.assertTrue((boolean)bufferPool.isDestroyed());
        Assert.assertEquals((long)0L, (long)bufferPool.getAvailableBuffers());
    }

    @Test(expected=IllegalStateException.class)
    public void testRequestBuffersAfterDestroyed() throws Exception {
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        bufferPool.requestBuffers();
        bufferPool.destroy();
        bufferPool.requestBuffers();
    }

    @Test
    public void testRecycleAfterDestroyed() throws Exception {
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        List buffers = bufferPool.requestBuffers();
        bufferPool.destroy();
        bufferPool.recycle((Collection)buffers);
        Assert.assertEquals((long)0L, (long)bufferPool.getAvailableBuffers());
    }

    @Test
    public void testDestroyWhileBlockingRequest() throws Exception {
        AtomicReference exception = new AtomicReference();
        BatchShuffleReadBufferPool bufferPool = this.createBufferPool();
        Thread requestThread = new Thread(() -> {
            try {
                while (true) {
                    bufferPool.requestBuffers();
                }
            }
            catch (Throwable throwable) {
                exception.set(throwable);
                return;
            }
        });
        requestThread.start();
        Thread.sleep(1000L);
        bufferPool.destroy();
        requestThread.join();
        Assert.assertTrue((boolean)(exception.get() instanceof IllegalStateException));
    }

    private BatchShuffleReadBufferPool createBufferPool(long totalBytes, int bufferSize) {
        return new BatchShuffleReadBufferPool(totalBytes, bufferSize);
    }

    private BatchShuffleReadBufferPool createBufferPool() {
        return this.createBufferPool(0x2000000L, 32768);
    }
}

