/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

@ExtendWith(value={TestLoggerExtension.class})
public class ApplicationStatusTest {
    private static final int SUCCESS_EXIT_CODE = 0;

    @Test
    public void succeededStatusMapsToSuccessExitCode() {
        int exitCode = ApplicationStatus.SUCCEEDED.processExitCode();
        Assertions.assertThat((int)exitCode).isEqualTo(0);
    }

    @Test
    public void cancelledStatusMapsToSuccessExitCode() {
        int exitCode = ApplicationStatus.CANCELED.processExitCode();
        Assertions.assertThat((int)exitCode).isEqualTo(0);
    }

    @Test
    public void notSucceededNorCancelledStatusMapsToNonSuccessExitCode() {
        Iterable<Integer> exitCodes = ApplicationStatusTest.exitCodes(ApplicationStatusTest.notSucceededNorCancelledStatus());
        Assertions.assertThat(exitCodes).doesNotContain((Object[])new Integer[]{0});
    }

    @Test
    public void testJobStatusFromSuccessApplicationStatus() {
        Assertions.assertThat((Comparable)ApplicationStatus.SUCCEEDED.deriveJobStatus()).isEqualTo((Object)JobStatus.FINISHED);
    }

    @Test
    public void testJobStatusFromFailedApplicationStatus() {
        Assertions.assertThat((Comparable)ApplicationStatus.FAILED.deriveJobStatus()).isEqualTo((Object)JobStatus.FAILED);
    }

    @Test
    public void testJobStatusFromCancelledApplicationStatus() {
        Assertions.assertThat((Comparable)ApplicationStatus.CANCELED.deriveJobStatus()).isEqualTo((Object)JobStatus.CANCELED);
    }

    @Test
    public void testJobStatusFailsFromUnknownApplicationStatuses() {
        Assertions.assertThatThrownBy(() -> ((ApplicationStatus)ApplicationStatus.UNKNOWN).deriveJobStatus()).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    public void testSuccessApplicationStatusFromJobStatus() {
        Assertions.assertThat((Comparable)ApplicationStatus.fromJobStatus((JobStatus)JobStatus.FINISHED)).isEqualTo((Object)ApplicationStatus.SUCCEEDED);
    }

    @Test
    public void testFailedApplicationStatusFromJobStatus() {
        Assertions.assertThat((Comparable)ApplicationStatus.fromJobStatus((JobStatus)JobStatus.FAILED)).isEqualTo((Object)ApplicationStatus.FAILED);
    }

    @Test
    public void testCancelledApplicationStatusFromJobStatus() {
        Assertions.assertThat((Comparable)ApplicationStatus.fromJobStatus((JobStatus)JobStatus.CANCELED)).isEqualTo((Object)ApplicationStatus.CANCELED);
    }

    @ParameterizedTest
    @EnumSource(value=JobStatus.class, names={"INITIALIZING", "CREATED", "RUNNING", "FAILING", "CANCELLING", "RESTARTING", "SUSPENDED", "RECONCILING"})
    public void testUnknownApplicationStatusFromJobStatus(JobStatus jobStatus) {
        Assertions.assertThat((Comparable)ApplicationStatus.fromJobStatus((JobStatus)jobStatus)).isEqualTo((Object)ApplicationStatus.UNKNOWN);
    }

    @Test
    public void testUnknownApplicationStatusForMissingJobStatus() {
        Assertions.assertThat((Comparable)ApplicationStatus.fromJobStatus(null)).isEqualTo((Object)ApplicationStatus.UNKNOWN);
    }

    private static Iterable<Integer> exitCodes(Iterable<ApplicationStatus> statuses) {
        return StreamSupport.stream(statuses.spliterator(), false).map(ApplicationStatus::processExitCode).collect(Collectors.toList());
    }

    private static Iterable<ApplicationStatus> notSucceededNorCancelledStatus() {
        return Arrays.stream(ApplicationStatus.values()).filter(ApplicationStatusTest::isNotSucceededNorCancelled).collect(Collectors.toList());
    }

    private static boolean isNotSucceededNorCancelled(ApplicationStatus status) {
        return status != ApplicationStatus.SUCCEEDED && status != ApplicationStatus.CANCELED;
    }
}

