/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.checkpoint.OperatorStateRepartitioner;
import org.apache.flink.runtime.checkpoint.RescaleMappings;

@NotThreadSafe
public class MappingBasedRepartitioner<T>
implements OperatorStateRepartitioner<T> {
    private final RescaleMappings newToOldSubtasksMapping;

    public MappingBasedRepartitioner(RescaleMappings newToOldSubtasksMapping) {
        this.newToOldSubtasksMapping = newToOldSubtasksMapping;
    }

    private static <T> List<T> extractOldState(List<List<T>> previousParallelSubtaskStates, int[] oldIndexes) {
        switch (oldIndexes.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return previousParallelSubtaskStates.get(oldIndexes[0]);
            }
        }
        return Arrays.stream(oldIndexes).boxed().flatMap(oldIndex -> ((List)previousParallelSubtaskStates.get((int)oldIndex)).stream()).collect(Collectors.toList());
    }

    @Override
    public List<List<T>> repartitionState(List<List<T>> previousParallelSubtaskStates, int oldParallelism, int newParallelism) {
        ArrayList<List<T>> repartitioned = new ArrayList<List<T>>();
        for (int newIndex = 0; newIndex < newParallelism; ++newIndex) {
            repartitioned.add(MappingBasedRepartitioner.extractOldState(previousParallelSubtaskStates, this.newToOldSubtasksMapping.getMappedIndexes(newIndex)));
        }
        return repartitioned;
    }
}

