/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.CompletedScheduledFuture;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adaptive.CreatingExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class CreatingExecutionGraphTest
extends TestLogger {
    @Test
    public void testCancelTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, new CompletableFuture(), this.log);
            context.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.CANCELED)));
            creatingExecutionGraph.cancel();
        }
    }

    @Test
    public void testSuspendTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, new CompletableFuture(), this.log);
            context.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.SUSPENDED)));
            creatingExecutionGraph.suspend((Throwable)new FlinkException("Job has been suspended."));
        }
    }

    @Test
    public void testGlobalFailureTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, new CompletableFuture(), this.log);
            context.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.FAILED)));
            creatingExecutionGraph.handleGlobalFailure((Throwable)new FlinkException("Test exception"));
        }
    }

    @Test
    public void testFailedExecutionGraphCreationTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CompletableFuture executionGraphWithVertexParallelismFuture = new CompletableFuture();
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, executionGraphWithVertexParallelismFuture, this.log);
            context.setExpectFinished(archivedExecutionGraph -> Assert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.FAILED)));
            executionGraphWithVertexParallelismFuture.completeExceptionally(new FlinkException("Test exception"));
        }
    }

    @Test
    public void testNotPossibleSlotAssignmentTransitionsToWaitingForResources() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithVertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, executionGraphWithVertexParallelismFuture, this.log);
            context.setTryToAssignSlotsFunction(ignored -> CreatingExecutionGraph.AssignmentResult.notPossible());
            context.setExpectWaitingForResources();
            executionGraphWithVertexParallelismFuture.complete(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism.create((ExecutionGraph)new StateTrackingMockExecutionGraph(), (VertexParallelism)new TestingVertexParallelism()));
        }
    }

    @Test
    public void testSuccessfulSlotAssignmentTransitionsToExecuting() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithvertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, executionGraphWithvertexParallelismFuture, this.log);
            StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
            context.setTryToAssignSlotsFunction(e -> CreatingExecutionGraph.AssignmentResult.success((ExecutionGraph)e.getExecutionGraph()));
            context.setExpectedExecuting(actualExecutionGraph -> Assert.assertThat((Object)actualExecutionGraph, (Matcher)Matchers.sameInstance((Object)executionGraph)));
            executionGraphWithvertexParallelismFuture.complete(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism.create((ExecutionGraph)executionGraph, (VertexParallelism)new TestingVertexParallelism()));
        }
    }

    static final class TestingVertexParallelism
    implements VertexParallelism {
        TestingVertexParallelism() {
        }

        public Map<JobVertexID, Integer> getMaxParallelismForVertices() {
            throw new UnsupportedOperationException("Is not supported");
        }

        public int getParallelism(JobVertexID jobVertexId) {
            throw new UnsupportedOperationException("Is not supported");
        }
    }

    static class MockCreatingExecutionGraphContext
    implements CreatingExecutionGraph.Context,
    AutoCloseable {
        private final StateValidator<ArchivedExecutionGraph> finishedStateValidator = new StateValidator("Finished");
        private final StateValidator<Void> waitingForResourcesStateValidator = new StateValidator("WaitingForResources");
        private final StateValidator<ExecutionGraph> executingStateValidator = new StateValidator("Executing");
        private Function<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism, CreatingExecutionGraph.AssignmentResult> tryToAssignSlotsFunction = e -> CreatingExecutionGraph.AssignmentResult.success((ExecutionGraph)e.getExecutionGraph());
        private boolean hadStateTransitionHappened = false;

        MockCreatingExecutionGraphContext() {
        }

        public void setExpectFinished(Consumer<ArchivedExecutionGraph> asserter) {
            this.finishedStateValidator.expectInput(asserter);
        }

        public void setExpectWaitingForResources() {
            this.waitingForResourcesStateValidator.expectInput(none -> {});
        }

        public void setExpectedExecuting(Consumer<ExecutionGraph> asserter) {
            this.executingStateValidator.expectInput(asserter);
        }

        public void setTryToAssignSlotsFunction(Function<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism, CreatingExecutionGraph.AssignmentResult> tryToAssignSlotsFunction) {
            this.tryToAssignSlotsFunction = tryToAssignSlotsFunction;
        }

        public void goToFinished(ArchivedExecutionGraph archivedExecutionGraph) {
            this.finishedStateValidator.validateInput(archivedExecutionGraph);
            this.hadStateTransitionHappened = true;
        }

        public void goToExecuting(ExecutionGraph executionGraph) {
            this.executingStateValidator.validateInput(executionGraph);
            this.hadStateTransitionHappened = true;
        }

        public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus jobStatus, @Nullable Throwable cause) {
            return ArchivedExecutionGraph.createFromInitializingJob((JobID)new JobID(), (String)"testJob", (JobStatus)jobStatus, (Throwable)cause, null, (long)0L);
        }

        public ScheduledFuture<?> runIfState(State expectedState, Runnable action, Duration delay) {
            if (!this.hadStateTransitionHappened) {
                action.run();
            }
            return CompletedScheduledFuture.create(null);
        }

        public CreatingExecutionGraph.AssignmentResult tryToAssignSlots(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism executionGraphWithVertexParallelism) {
            return this.tryToAssignSlotsFunction.apply(executionGraphWithVertexParallelism);
        }

        public void goToWaitingForResources() {
            this.waitingForResourcesStateValidator.validateInput(null);
            this.hadStateTransitionHappened = true;
        }

        @Override
        public void close() throws Exception {
            this.finishedStateValidator.close();
            this.waitingForResourcesStateValidator.close();
            this.executingStateValidator.close();
        }
    }
}

