/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.util.concurrent.FutureUtils;

public class TestRestHandler<G extends RestfulGateway, REQ extends RequestBody, RES extends ResponseBody, M extends MessageParameters>
extends AbstractRestHandler<G, REQ, RES, M> {
    private final Queue<CompletableFuture<RES>> responseQueue;

    public TestRestHandler(GatewayRetriever<G> gatewayRetriever, MessageHeaders<REQ, RES, M> messageHeaders, CompletableFuture<RES> ... responses) {
        super(gatewayRetriever, RpcUtils.INF_TIMEOUT, Collections.emptyMap(), messageHeaders);
        this.responseQueue = new ArrayDeque<CompletableFuture<RES>>(Arrays.asList(responses));
    }

    protected CompletableFuture<RES> handleRequest(@Nullable HandlerRequest<REQ, M> request, @Nullable G gateway) throws RestHandlerException {
        CompletableFuture<RES> result = this.responseQueue.poll();
        if (result != null) {
            return result;
        }
        return FutureUtils.completedExceptionally((Throwable)new NoSuchElementException("No pre-defined Futures left."));
    }
}

