/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotState;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerSlotInformation;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;

public final class TestingTaskManagerSlotInformation
implements TaskManagerSlotInformation {
    private final SlotID slotId;
    private final InstanceID instanceId;
    @Nullable
    private final AllocationID allocationId;
    @Nullable
    private final JobID jobId;
    private final ResourceProfile resourceProfile;
    private final SlotState state;
    private final TaskExecutorConnection taskExecutorConnection = new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());

    private TestingTaskManagerSlotInformation(SlotID slotId, @Nullable AllocationID allocationId, @Nullable JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile, SlotState state) {
        this.slotId = slotId;
        this.allocationId = allocationId;
        this.jobId = jobId;
        this.instanceId = instanceId;
        this.resourceProfile = resourceProfile;
        this.state = state;
    }

    public SlotID getSlotId() {
        return this.slotId;
    }

    @Nullable
    public JobID getJobId() {
        return this.jobId;
    }

    @Nullable
    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public SlotState getState() {
        return this.state;
    }

    public InstanceID getInstanceId() {
        return this.instanceId;
    }

    public TaskExecutorConnection getTaskManagerConnection() {
        return this.taskExecutorConnection;
    }

    public boolean isMatchingRequirement(ResourceProfile required) {
        return this.resourceProfile.isMatching(required);
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static class Builder {
        private SlotID slotId = new SlotID(ResourceID.generate(), 0);
        private AllocationID allocationId = new AllocationID();
        private JobID jobId = new JobID();
        private InstanceID instanceId = new InstanceID();
        private ResourceProfile resourceProfile = ResourceProfile.ANY;
        private SlotState state = SlotState.FREE;

        Builder() {
        }

        public Builder setState(SlotState state) {
            this.state = state;
            return this;
        }

        public Builder setInstanceId(InstanceID instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setResourceProfile(ResourceProfile resourceProfile) {
            this.resourceProfile = resourceProfile;
            return this;
        }

        public Builder setSlotId(SlotID slotId) {
            this.slotId = slotId;
            return this;
        }

        public Builder setAllocationId(AllocationID allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public Builder setJobId(JobID jobId) {
            this.jobId = jobId;
            return this;
        }

        public TestingTaskManagerSlotInformation build() {
            return new TestingTaskManagerSlotInformation(this.slotId, this.allocationId, this.jobId, this.instanceId, this.resourceProfile, this.state);
        }
    }
}

