/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.registration.DefaultTestRegistrationGateway;
import org.apache.flink.runtime.registration.ManualResponseTestRegistrationGateway;
import org.apache.flink.runtime.registration.RegisteredRpcConnection;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.RetryingRegistration;
import org.apache.flink.runtime.registration.RetryingRegistrationTest;
import org.apache.flink.runtime.registration.TestRegistrationGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.types.Either;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class RegisteredRpcConnectionTest
extends TestLogger {
    private TestingRpcService rpcService;

    @Before
    public void setup() {
        this.rpcService = new TestingRpcService();
    }

    @After
    public void tearDown() throws ExecutionException, InterruptedException {
        if (this.rpcService != null) {
            this.rpcService.stopService().get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessfulRpcConnection() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        ManualResponseTestRegistrationGateway testGateway = new ManualResponseTestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        try {
            this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
            connection.start();
            Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> connectionResult = connection.getConnectionFuture().get();
            Assert.assertTrue((boolean)connectionResult.isLeft());
            String actualConnectionId = ((RetryingRegistrationTest.TestRegistrationSuccess)((Object)connectionResult.left())).getCorrelationId();
            Assert.assertTrue((boolean)connection.isConnected());
            Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
            Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
            Assert.assertEquals((Object)testGateway, (Object)connection.getTargetGateway());
            Assert.assertEquals((Object)"Test RPC Connection ID", (Object)actualConnectionId);
        }
        finally {
            testGateway.stop();
        }
    }

    @Test
    public void testRpcConnectionFailures() throws Exception {
        String connectionFailureMessage = "Test RPC Connection failure";
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        RuntimeException registrationException = new RuntimeException("Test RPC Connection failure");
        DefaultTestRegistrationGateway testGateway = DefaultTestRegistrationGateway.newBuilder().setRegistrationFunction((uuid, aLong) -> {
            throw registrationException;
        }).build();
        this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
        TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
        connection.start();
        try {
            connection.getConnectionFuture().get();
            Assert.fail((String)"expected failure.");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals((Object)registrationException, (Object)ee.getCause());
        }
        Assert.assertFalse((boolean)connection.isConnected());
        Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
        Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
        Assert.assertNull((Object)connection.getTargetGateway());
    }

    @Test
    public void testRpcConnectionRejectionCallsOnRegistrationRejection() {
        DefaultTestRegistrationGateway testRegistrationGateway = DefaultTestRegistrationGateway.newBuilder().setRegistrationFunction((uuid, aLong) -> CompletableFuture.completedFuture(new RetryingRegistrationTest.TestRegistrationRejection(RetryingRegistrationTest.TestRegistrationRejection.RejectionReason.REJECTED))).build();
        this.rpcService.registerGateway(testRegistrationGateway.getAddress(), testRegistrationGateway);
        TestRpcConnection connection = new TestRpcConnection(testRegistrationGateway.getAddress(), UUID.randomUUID(), (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
        connection.start();
        Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> connectionResult = connection.getConnectionFuture().join();
        Assert.assertTrue((boolean)connectionResult.isRight());
        RetryingRegistrationTest.TestRegistrationRejection registrationRejection = (RetryingRegistrationTest.TestRegistrationRejection)((Object)connectionResult.right());
        Assert.assertThat((Object)((Object)registrationRejection.getRejectionReason()), (Matcher)Matchers.is((Object)((Object)RetryingRegistrationTest.TestRegistrationRejection.RejectionReason.REJECTED)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRpcConnectionClose() throws Exception {
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        String connectionID = "Test RPC Connection ID";
        ManualResponseTestRegistrationGateway testGateway = new ManualResponseTestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID")});
        try {
            this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
            TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
            connection.start();
            connection.close();
            Assert.assertEquals((Object)"<TestRpcConnectionEndpointAddress>", (Object)connection.getTargetAddress());
            Assert.assertEquals((Object)leaderId, (Object)connection.getTargetLeaderId());
            Assert.assertTrue((boolean)connection.isClosed());
        }
        finally {
            testGateway.stop();
        }
    }

    @Test
    public void testReconnect() throws Exception {
        String connectionId1 = "Test RPC Connection ID 1";
        String connectionId2 = "Test RPC Connection ID 2";
        String testRpcConnectionEndpointAddress = "<TestRpcConnectionEndpointAddress>";
        UUID leaderId = UUID.randomUUID();
        ManualResponseTestRegistrationGateway testGateway = new ManualResponseTestRegistrationGateway(new RegistrationResponse[]{new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID 1"), new RetryingRegistrationTest.TestRegistrationSuccess("Test RPC Connection ID 2")});
        this.rpcService.registerGateway("<TestRpcConnectionEndpointAddress>", testGateway);
        TestRpcConnection connection = new TestRpcConnection("<TestRpcConnectionEndpointAddress>", leaderId, (Executor)this.rpcService.getScheduledExecutor(), this.rpcService);
        connection.start();
        Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> firstConnectionResult = connection.getConnectionFuture().get();
        Assert.assertTrue((boolean)firstConnectionResult.isLeft());
        String actualConnectionId1 = ((RetryingRegistrationTest.TestRegistrationSuccess)((Object)firstConnectionResult.left())).getCorrelationId();
        Assert.assertEquals((Object)actualConnectionId1, (Object)"Test RPC Connection ID 1");
        Assert.assertTrue((boolean)connection.tryReconnect());
        Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> secondConnectionResult = connection.getConnectionFuture().get();
        Assert.assertTrue((boolean)secondConnectionResult.isLeft());
        String actualConnectionId2 = ((RetryingRegistrationTest.TestRegistrationSuccess)((Object)secondConnectionResult.left())).getCorrelationId();
        Assert.assertEquals((Object)actualConnectionId2, (Object)"Test RPC Connection ID 2");
    }

    private static class TestRpcConnection
    extends RegisteredRpcConnection<UUID, TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> {
        private final Object lock = new Object();
        private final RpcService rpcService;
        private CompletableFuture<Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>> connectionFuture;

        public TestRpcConnection(String targetAddress, UUID targetLeaderId, Executor executor, RpcService rpcService) {
            super(LoggerFactory.getLogger(RegisteredRpcConnectionTest.class), targetAddress, (Serializable)targetLeaderId, executor);
            this.rpcService = rpcService;
            this.connectionFuture = new CompletableFuture();
        }

        protected RetryingRegistration<UUID, TestRegistrationGateway, RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection> generateRegistration() {
            return new RetryingRegistrationTest.TestRetryingRegistration(this.rpcService, this.getTargetAddress(), (UUID)this.getTargetLeaderId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationSuccess(RetryingRegistrationTest.TestRegistrationSuccess success) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.complete((Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>)Either.Left((Object)((Object)success)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationRejection(RetryingRegistrationTest.TestRegistrationRejection rejection) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.complete((Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>)Either.Right((Object)((Object)rejection)));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onRegistrationFailure(Throwable failure) {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.completeExceptionally(failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryReconnect() {
            Object object = this.lock;
            synchronized (object) {
                this.connectionFuture.cancel(false);
                this.connectionFuture = new CompletableFuture();
            }
            return super.tryReconnect();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<Either<RetryingRegistrationTest.TestRegistrationSuccess, RetryingRegistrationTest.TestRegistrationRejection>> getConnectionFuture() {
            Object object = this.lock;
            synchronized (object) {
                return this.connectionFuture;
            }
        }
    }
}

