/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskManagerGroupTest
extends TestLogger {
    private MetricRegistryImpl registry;

    @Before
    public void setup() {
        this.registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
    }

    @After
    public void teardown() throws Exception {
        if (this.registry != null) {
            this.registry.shutdown().get();
        }
    }

    @Test
    public void addAndRemoveJobs() throws IOException {
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"localhost", (ResourceID)ResourceID.generate());
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobVertexID vertex11 = new JobVertexID();
        JobVertexID vertex12 = new JobVertexID();
        JobVertexID vertex13 = new JobVertexID();
        JobVertexID vertex21 = new JobVertexID();
        ExecutionAttemptID execution11 = new ExecutionAttemptID();
        ExecutionAttemptID execution12 = new ExecutionAttemptID();
        ExecutionAttemptID execution13 = new ExecutionAttemptID();
        ExecutionAttemptID execution21 = new ExecutionAttemptID();
        TaskMetricGroup tmGroup11 = group.addTaskForJob(jid1, "testjob", vertex11, execution11, "test", 17, 0);
        TaskMetricGroup tmGroup12 = group.addTaskForJob(jid1, "testjob", vertex12, execution12, "test", 13, 1);
        TaskMetricGroup tmGroup21 = group.addTaskForJob(jid2, "anotherJob", vertex21, execution21, "test", 7, 2);
        Assert.assertEquals((long)2L, (long)group.numRegisteredJobMetricGroups());
        Assert.assertFalse((boolean)tmGroup11.parent().isClosed());
        Assert.assertFalse((boolean)tmGroup12.parent().isClosed());
        Assert.assertFalse((boolean)tmGroup21.parent().isClosed());
        tmGroup11.close();
        tmGroup21.close();
        Assert.assertTrue((boolean)tmGroup11.isClosed());
        Assert.assertTrue((boolean)tmGroup21.isClosed());
        Assert.assertFalse((boolean)tmGroup11.parent().isClosed());
        Assert.assertFalse((boolean)tmGroup12.parent().isClosed());
        Assert.assertTrue((boolean)tmGroup21.parent().isClosed());
        Assert.assertEquals((long)1L, (long)group.numRegisteredJobMetricGroups());
        TaskMetricGroup tmGroup13 = group.addTaskForJob(jid1, "testjob", vertex13, execution13, "test", 0, 0);
        tmGroup12.close();
        tmGroup13.close();
        Assert.assertTrue((boolean)tmGroup11.parent().isClosed());
        Assert.assertTrue((boolean)tmGroup12.parent().isClosed());
        Assert.assertTrue((boolean)tmGroup13.parent().isClosed());
        Assert.assertEquals((long)0L, (long)group.numRegisteredJobMetricGroups());
    }

    @Test
    public void testCloseClosesAll() throws IOException {
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"localhost", (ResourceID)new ResourceID(new AbstractID().toString()));
        JobID jid1 = new JobID();
        JobID jid2 = new JobID();
        String jobName1 = "testjob";
        String jobName2 = "anotherJob";
        JobVertexID vertex11 = new JobVertexID();
        JobVertexID vertex12 = new JobVertexID();
        JobVertexID vertex21 = new JobVertexID();
        ExecutionAttemptID execution11 = new ExecutionAttemptID();
        ExecutionAttemptID execution12 = new ExecutionAttemptID();
        ExecutionAttemptID execution21 = new ExecutionAttemptID();
        TaskMetricGroup tmGroup11 = group.addTaskForJob(jid1, "testjob", vertex11, execution11, "test", 17, 0);
        TaskMetricGroup tmGroup12 = group.addTaskForJob(jid1, "testjob", vertex12, execution12, "test", 13, 1);
        TaskMetricGroup tmGroup21 = group.addTaskForJob(jid2, "anotherJob", vertex21, execution21, "test", 7, 1);
        group.close();
        Assert.assertTrue((boolean)tmGroup11.isClosed());
        Assert.assertTrue((boolean)tmGroup12.isClosed());
        Assert.assertTrue((boolean)tmGroup21.isClosed());
    }

    @Test
    public void testGenerateScopeDefault() {
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"localhost", (ResourceID)new ResourceID("id"));
        Assert.assertArrayEquals((Object[])new String[]{"localhost", "taskmanager", "id"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"localhost.taskmanager.id.name", (Object)group.getMetricIdentifier("name"));
    }

    @Test
    public void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.setString(MetricOptions.SCOPE_NAMING_TM, "constant.<host>.foo.<host>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        TaskManagerMetricGroup group = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        Assert.assertArrayEquals((Object[])new String[]{"constant", "host", "foo", "host"}, (Object[])group.getScopeComponents());
        Assert.assertEquals((Object)"constant.host.foo.host.name", (Object)group.getMetricIdentifier("name"));
        registry.shutdown().get();
    }

    @Test
    public void testCreateQueryServiceMetricInfo() {
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"host", (ResourceID)new ResourceID("id"));
        QueryScopeInfo.TaskManagerQueryScopeInfo info = tm.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assert.assertEquals((Object)"", (Object)info.scope);
        Assert.assertEquals((Object)"id", (Object)info.taskManagerID);
    }
}

