/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderretrieval;

import java.util.UUID;
import java.util.concurrent.TimeoutException;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingListener;
import org.apache.flink.runtime.leaderretrieval.DefaultLeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalDriverFactory;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.TestingLeaderRetrievalDriver;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.RunnableWithException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultLeaderRetrievalServiceTest
extends TestLogger {
    private static final String TEST_URL = "akka//user/jobmanager";
    private static final long timeout = 50L;

    @Test
    public void testNotifyLeaderAddress() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    LeaderInformation newLeader = LeaderInformation.known((UUID)UUID.randomUUID(), (String)DefaultLeaderRetrievalServiceTest.TEST_URL);
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    this.testingListener.waitForNewLeader(50L);
                    Assert.assertThat((Object)this.testingListener.getLeaderSessionID(), (Matcher)Matchers.is((Object)newLeader.getLeaderSessionID()));
                    Assert.assertThat((Object)this.testingListener.getAddress(), (Matcher)Matchers.is((Object)newLeader.getLeaderAddress()));
                });
            }
        };
    }

    @Test
    public void testNotifyLeaderAddressEmpty() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    LeaderInformation newLeader = LeaderInformation.known((UUID)UUID.randomUUID(), (String)DefaultLeaderRetrievalServiceTest.TEST_URL);
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    this.testingListener.waitForNewLeader(50L);
                    this.testingLeaderRetrievalDriver.onUpdate(LeaderInformation.empty());
                    this.testingListener.waitForEmptyLeaderInformation(50L);
                    Assert.assertThat((Object)this.testingListener.getLeaderSessionID(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                    Assert.assertThat((Object)this.testingListener.getAddress(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                });
            }
        };
    }

    @Test
    public void testErrorForwarding() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    Exception testException = new Exception("test exception");
                    this.testingLeaderRetrievalDriver.onFatalError(testException);
                    this.testingListener.waitForError(50L);
                    Assert.assertThat((Object)this.testingListener.getError(), (Matcher)FlinkMatchers.containsCause((Throwable)testException));
                });
            }
        };
    }

    @Test
    public void testErrorIsIgnoredAfterBeingStop() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    Exception testException = new Exception("test exception");
                    this.leaderRetrievalService.stop();
                    this.testingLeaderRetrievalDriver.onFatalError(testException);
                    try {
                        this.testingListener.waitForError(50L);
                        Assert.fail((String)"We expect to have a timeout here because there's no error should be passed to listener.");
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    Assert.assertThat((Object)this.testingListener.getError(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
                });
            }
        };
    }

    @Test
    public void testNotifyLeaderAddressOnlyWhenLeaderTrulyChanged() throws Exception {
        new Context(){
            {
                this.runTest(() -> {
                    LeaderInformation newLeader = LeaderInformation.known((UUID)UUID.randomUUID(), (String)DefaultLeaderRetrievalServiceTest.TEST_URL);
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    Assert.assertThat((Object)this.testingListener.getLeaderEventQueueSize(), (Matcher)Matchers.is((Object)1));
                    this.testingLeaderRetrievalDriver.onUpdate(newLeader);
                    Assert.assertThat((Object)this.testingListener.getLeaderEventQueueSize(), (Matcher)Matchers.is((Object)1));
                    this.testingLeaderRetrievalDriver.onUpdate(LeaderInformation.known((UUID)UUID.randomUUID(), (String)"akka//user/jobmanager1"));
                    Assert.assertThat((Object)this.testingListener.getLeaderEventQueueSize(), (Matcher)Matchers.is((Object)2));
                });
            }
        };
    }

    private class Context {
        private final TestingLeaderRetrievalDriver.TestingLeaderRetrievalDriverFactory leaderRetrievalDriverFactory = new TestingLeaderRetrievalDriver.TestingLeaderRetrievalDriverFactory();
        final DefaultLeaderRetrievalService leaderRetrievalService = new DefaultLeaderRetrievalService((LeaderRetrievalDriverFactory)this.leaderRetrievalDriverFactory);
        final TestingListener testingListener = new TestingListener();
        TestingLeaderRetrievalDriver testingLeaderRetrievalDriver;

        private Context() {
        }

        void runTest(RunnableWithException testMethod) throws Exception {
            this.leaderRetrievalService.start((LeaderRetrievalListener)this.testingListener);
            this.testingLeaderRetrievalDriver = this.leaderRetrievalDriverFactory.getCurrentRetrievalDriver();
            Assert.assertThat((Object)this.testingLeaderRetrievalDriver, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            testMethod.run();
            this.leaderRetrievalService.stop();
        }
    }
}

