/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegmentProvider;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NoOpBufferPool;
import org.apache.flink.runtime.io.network.partition.InputChannelTestUtils;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateFactory;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.taskmanager.NettyShuffleEnvironmentConfiguration;
import org.apache.flink.util.function.SupplierWithException;

public class SingleInputGateBuilder {
    public static final PartitionProducerStateProvider NO_OP_PRODUCER_CHECKER = (dsid, id, consumer) -> {};
    private final IntermediateDataSetID intermediateDataSetID = new IntermediateDataSetID();
    private final int bufferSize = 4096;
    private ResultPartitionType partitionType = ResultPartitionType.PIPELINED;
    private int consumedSubpartitionIndex = 0;
    private int gateIndex = 0;
    private int numberOfChannels = 1;
    private PartitionProducerStateProvider partitionProducerStateProvider = NO_OP_PRODUCER_CHECKER;
    private BufferDecompressor bufferDecompressor = null;
    private MemorySegmentProvider segmentProvider = InputChannelTestUtils.StubMemorySegmentProvider.getInstance();
    private ChannelStateWriter channelStateWriter = ChannelStateWriter.NO_OP;
    @Nullable
    private BiFunction<InputChannelBuilder, SingleInputGate, InputChannel> channelFactory = null;
    private SupplierWithException<BufferPool, IOException> bufferPoolFactory = NoOpBufferPool::new;

    public SingleInputGateBuilder setPartitionProducerStateProvider(PartitionProducerStateProvider partitionProducerStateProvider) {
        this.partitionProducerStateProvider = partitionProducerStateProvider;
        return this;
    }

    public SingleInputGateBuilder setResultPartitionType(ResultPartitionType partitionType) {
        this.partitionType = partitionType;
        return this;
    }

    public SingleInputGateBuilder setConsumedSubpartitionIndex(int consumedSubpartitionIndex) {
        this.consumedSubpartitionIndex = consumedSubpartitionIndex;
        return this;
    }

    public SingleInputGateBuilder setSingleInputGateIndex(int gateIndex) {
        this.gateIndex = gateIndex;
        return this;
    }

    public SingleInputGateBuilder setNumberOfChannels(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
        return this;
    }

    public SingleInputGateBuilder setupBufferPoolFactory(NettyShuffleEnvironment environment) {
        NettyShuffleEnvironmentConfiguration config = environment.getConfiguration();
        this.bufferPoolFactory = SingleInputGateFactory.createBufferPoolFactory((BufferPoolFactory)environment.getNetworkBufferPool(), (int)config.floatingNetworkBuffersPerGate());
        this.segmentProvider = environment.getNetworkBufferPool();
        return this;
    }

    public SingleInputGateBuilder setBufferPoolFactory(BufferPool bufferPool) {
        this.bufferPoolFactory = () -> bufferPool;
        return this;
    }

    public SingleInputGateBuilder setBufferDecompressor(BufferDecompressor bufferDecompressor) {
        this.bufferDecompressor = bufferDecompressor;
        return this;
    }

    public SingleInputGateBuilder setSegmentProvider(MemorySegmentProvider segmentProvider) {
        this.segmentProvider = segmentProvider;
        return this;
    }

    public SingleInputGateBuilder setChannelFactory(BiFunction<InputChannelBuilder, SingleInputGate, InputChannel> channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public SingleInputGateBuilder setChannelStateWriter(ChannelStateWriter channelStateWriter) {
        this.channelStateWriter = channelStateWriter;
        return this;
    }

    public SingleInputGate build() {
        SingleInputGate gate = new SingleInputGate("Single Input Gate", this.gateIndex, this.intermediateDataSetID, this.partitionType, this.consumedSubpartitionIndex, this.numberOfChannels, this.partitionProducerStateProvider, this.bufferPoolFactory, this.bufferDecompressor, this.segmentProvider, 4096);
        if (this.channelFactory != null) {
            gate.setInputChannels((InputChannel[])IntStream.range(0, this.numberOfChannels).mapToObj(index -> this.channelFactory.apply(InputChannelBuilder.newBuilder().setStateWriter(this.channelStateWriter).setChannelIndex(index), gate)).toArray(InputChannel[]::new));
        }
        return gate;
    }
}

