/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.flink.runtime.io.disk.BatchShuffleReadBufferPool;
import org.apache.flink.runtime.io.disk.FileChannelManager;
import org.apache.flink.runtime.io.disk.NoOpFileChannelManager;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolFactory;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.partition.BoundedBlockingSubpartitionType;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionFactory;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.function.SupplierWithException;

public class ResultPartitionBuilder {
    private ResultPartitionID partitionId = new ResultPartitionID();
    private ResultPartitionType partitionType = ResultPartitionType.PIPELINED;
    private BoundedBlockingSubpartitionType blockingSubpartitionType = BoundedBlockingSubpartitionType.AUTO;
    private int partitionIndex = 0;
    private int numberOfSubpartitions = 1;
    private int numTargetKeyGroups = 1;
    private ResultPartitionManager partitionManager = new ResultPartitionManager();
    private FileChannelManager channelManager = NoOpFileChannelManager.INSTANCE;
    private NetworkBufferPool networkBufferPool = new NetworkBufferPool(2, 1);
    private BatchShuffleReadBufferPool batchShuffleReadBufferPool = new BatchShuffleReadBufferPool(0x200000L, 32768);
    private ExecutorService batchShuffleReadIOExecutor = Executors.newDirectExecutorService();
    private int networkBuffersPerChannel = 1;
    private int floatingNetworkBuffersPerGate = 1;
    private int sortShuffleMinBuffers = 100;
    private int sortShuffleMinParallelism = Integer.MAX_VALUE;
    private int maxBuffersPerChannel = Integer.MAX_VALUE;
    private int networkBufferSize = 1;
    private Optional<SupplierWithException<BufferPool, IOException>> bufferPoolFactory = Optional.empty();
    private boolean blockingShuffleCompressionEnabled = false;
    private boolean sslEnabled = false;
    private String compressionCodec = "LZ4";

    public ResultPartitionBuilder setResultPartitionIndex(int partitionIndex) {
        this.partitionIndex = partitionIndex;
        return this;
    }

    public ResultPartitionBuilder setResultPartitionId(ResultPartitionID partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public ResultPartitionBuilder setResultPartitionType(ResultPartitionType partitionType) {
        this.partitionType = partitionType;
        return this;
    }

    public ResultPartitionBuilder setNumberOfSubpartitions(int numberOfSubpartitions) {
        this.numberOfSubpartitions = numberOfSubpartitions;
        return this;
    }

    public ResultPartitionBuilder setNumTargetKeyGroups(int numTargetKeyGroups) {
        this.numTargetKeyGroups = numTargetKeyGroups;
        return this;
    }

    public ResultPartitionBuilder setResultPartitionManager(ResultPartitionManager partitionManager) {
        this.partitionManager = partitionManager;
        return this;
    }

    public ResultPartitionBuilder setFileChannelManager(FileChannelManager channelManager) {
        this.channelManager = channelManager;
        return this;
    }

    public ResultPartitionBuilder setupBufferPoolFactoryFromNettyShuffleEnvironment(NettyShuffleEnvironment environment) {
        return this.setNetworkBuffersPerChannel(environment.getConfiguration().networkBuffersPerChannel()).setFloatingNetworkBuffersPerGate(environment.getConfiguration().floatingNetworkBuffersPerGate()).setNetworkBufferSize(environment.getConfiguration().networkBufferSize()).setNetworkBufferPool(environment.getNetworkBufferPool()).setBatchShuffleReadBufferPool(environment.getBatchShuffleReadBufferPool()).setBatchShuffleReadIOExecutor(environment.getBatchShuffleReadIOExecutor()).setSortShuffleMinBuffers(environment.getConfiguration().sortShuffleMinBuffers()).setSortShuffleMinParallelism(environment.getConfiguration().sortShuffleMinParallelism());
    }

    public ResultPartitionBuilder setNetworkBufferPool(NetworkBufferPool networkBufferPool) {
        this.networkBufferPool = networkBufferPool;
        return this;
    }

    public ResultPartitionBuilder setBatchShuffleReadBufferPool(BatchShuffleReadBufferPool batchShuffleReadBufferPool) {
        this.batchShuffleReadBufferPool = batchShuffleReadBufferPool;
        return this;
    }

    public ResultPartitionBuilder setBatchShuffleReadIOExecutor(ExecutorService batchShuffleReadIOExecutor) {
        this.batchShuffleReadIOExecutor = batchShuffleReadIOExecutor;
        return this;
    }

    public ResultPartitionBuilder setNetworkBuffersPerChannel(int networkBuffersPerChannel) {
        this.networkBuffersPerChannel = networkBuffersPerChannel;
        return this;
    }

    public ResultPartitionBuilder setFloatingNetworkBuffersPerGate(int floatingNetworkBuffersPerGate) {
        this.floatingNetworkBuffersPerGate = floatingNetworkBuffersPerGate;
        return this;
    }

    ResultPartitionBuilder setNetworkBufferSize(int networkBufferSize) {
        this.networkBufferSize = networkBufferSize;
        return this;
    }

    public ResultPartitionBuilder setBufferPoolFactory(SupplierWithException<BufferPool, IOException> bufferPoolFactory) {
        this.bufferPoolFactory = Optional.of(bufferPoolFactory);
        return this;
    }

    public ResultPartitionBuilder setBlockingShuffleCompressionEnabled(boolean blockingShuffleCompressionEnabled) {
        this.blockingShuffleCompressionEnabled = blockingShuffleCompressionEnabled;
        return this;
    }

    public ResultPartitionBuilder setSortShuffleMinBuffers(int sortShuffleMinBuffers) {
        this.sortShuffleMinBuffers = sortShuffleMinBuffers;
        return this;
    }

    public ResultPartitionBuilder setSortShuffleMinParallelism(int sortShuffleMinParallelism) {
        this.sortShuffleMinParallelism = sortShuffleMinParallelism;
        return this;
    }

    public ResultPartitionBuilder setCompressionCodec(String compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    ResultPartitionBuilder setBoundedBlockingSubpartitionType(BoundedBlockingSubpartitionType blockingSubpartitionType) {
        this.blockingSubpartitionType = blockingSubpartitionType;
        return this;
    }

    public ResultPartitionBuilder setSSLEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        return this;
    }

    public ResultPartition build() {
        ResultPartitionFactory resultPartitionFactory = new ResultPartitionFactory(this.partitionManager, this.channelManager, (BufferPoolFactory)this.networkBufferPool, this.batchShuffleReadBufferPool, this.batchShuffleReadIOExecutor, this.blockingSubpartitionType, this.networkBuffersPerChannel, this.floatingNetworkBuffersPerGate, this.networkBufferSize, this.blockingShuffleCompressionEnabled, this.compressionCodec, this.maxBuffersPerChannel, this.sortShuffleMinBuffers, this.sortShuffleMinParallelism, this.sslEnabled);
        SupplierWithException factory = this.bufferPoolFactory.orElseGet(() -> resultPartitionFactory.createBufferPoolFactory(this.numberOfSubpartitions, this.partitionType));
        return resultPartitionFactory.create("Result Partition task", this.partitionIndex, this.partitionId, this.partitionType, this.numberOfSubpartitions, this.numTargetKeyGroups, factory);
    }
}

