/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class BlobServerSSLTest
extends TestLogger {
    @Test
    public void testFailedToInitWithTwoProtocolsSet() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        config.setString(SecurityOptions.SSL_KEYSTORE, ((Object)((Object)this)).getClass().getResource("/local127.keystore").getPath());
        config.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_TRUSTSTORE, ((Object)((Object)this)).getClass().getResource("/local127.truststore").getPath());
        config.setString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_ALGORITHMS, "TLSv1,TLSv1.1");
        try (BlobServer ignored = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            Assert.fail();
        }
        catch (Exception e) {
            ExceptionUtils.findThrowable((Throwable)e, IOException.class);
            ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)"Unable to open BLOB Server in specified port range: 0");
        }
    }

    @Test
    public void testFailedToInitWithInvalidSslKeystoreConfigured() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        config.setString(SecurityOptions.SSL_KEYSTORE, "invalid.keystore");
        config.setString(SecurityOptions.SSL_KEYSTORE_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_KEY_PASSWORD, "password");
        config.setString(SecurityOptions.SSL_TRUSTSTORE, "invalid.keystore");
        config.setString(SecurityOptions.SSL_TRUSTSTORE_PASSWORD, "password");
        try (BlobServer ignored = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            Assert.fail();
        }
        catch (Exception e) {
            ExceptionUtils.findThrowable((Throwable)e, IOException.class);
            ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)"Failed to initialize SSL for the blob server");
        }
    }

    @Test
    public void testFailedToInitWithMissingMandatorySslConfiguration() {
        Configuration config = new Configuration();
        config.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        try (BlobServer ignored = new BlobServer(config, (BlobStore)new VoidBlobStore());){
            Assert.fail();
        }
        catch (Exception e) {
            ExceptionUtils.findThrowable((Throwable)e, IOException.class);
            ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)"Failed to initialize SSL for the blob server");
        }
    }
}

