/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.Preconditions;

public class ContainerSpecification
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Configuration systemProperties;
    private final List<Artifact> artifacts = new LinkedList<Artifact>();
    private final Map<String, String> environmentVariables = new HashMap<String, String>();
    private final Configuration flinkConfiguration;

    public ContainerSpecification() {
        this.systemProperties = new Configuration();
        this.flinkConfiguration = new Configuration();
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public Configuration getFlinkConfiguration() {
        return this.flinkConfiguration;
    }

    public Configuration getSystemProperties() {
        return this.systemProperties;
    }

    public String toString() {
        return "ContainerSpecification{environmentVariables=" + this.environmentVariables + ", systemProperties=" + this.systemProperties + ", dynamicConfiguration=" + this.flinkConfiguration + ", artifacts=" + this.artifacts + '}';
    }

    public static ContainerSpecification from(Configuration flinkConfiguration) {
        ContainerSpecification containerSpecification = new ContainerSpecification();
        containerSpecification.getFlinkConfiguration().addAll(flinkConfiguration);
        return containerSpecification;
    }

    public static String formatSystemProperties(Configuration jvmArgs) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : jvmArgs.toMap().entrySet()) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            String dynamicProperty = ContainerSpecification.createDynamicProperty((String)entry.getKey(), (String)entry.getValue());
            sb.append(dynamicProperty);
        }
        return sb.toString();
    }

    public static String createDynamicProperty(String key, String value) {
        String keyPart = "-D" + key + '=';
        String valuePart = value.contains(" ") ? "\"" + value + "\"" : value;
        return keyPart + valuePart;
    }

    public static class Artifact {
        public final Path source;
        public final Path dest;
        public final boolean executable;
        public final boolean cachable;
        public final boolean extract;

        public Artifact(Path source, Path dest, boolean executable, boolean cachable, boolean extract) {
            Preconditions.checkArgument((boolean)source.isAbsolute(), (Object)"source must be absolute");
            Preconditions.checkArgument((!dest.isAbsolute() ? 1 : 0) != 0, (Object)"destination must be relative");
            this.source = source;
            this.dest = dest;
            this.executable = executable;
            this.cachable = cachable;
            this.extract = extract;
        }

        public String toString() {
            return "Artifact{source=" + this.source + ", dest=" + this.dest + ", executable=" + this.executable + ", cachable=" + this.cachable + ", extract=" + this.extract + '}';
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static class Builder {
            public Path source;
            public Path dest;
            public boolean executable = false;
            public boolean cachable = true;
            public boolean extract = false;

            public Builder setSource(Path source) {
                this.source = source;
                return this;
            }

            public Builder setDest(Path dest) {
                this.dest = dest;
                return this;
            }

            public Builder setCachable(boolean cachable) {
                this.cachable = cachable;
                return this;
            }

            public Builder setExtract(boolean extract) {
                this.extract = extract;
                return this;
            }

            public Builder setExecutable(boolean executable) {
                this.executable = executable;
                return this;
            }

            public Artifact build() {
                return new Artifact(this.source, this.dest, this.executable, this.cachable, this.extract);
            }
        }
    }
}

