/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.runtime.webmonitor.WebRuntimeMonitor;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpMethod;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpObject;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.QueryStringEncoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.DiskFileUpload;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpDataFactory;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import org.apache.flink.util.ExceptionUtils;

@ChannelHandler.Sharable
public class HttpRequestHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final Charset ENCODING = ConfigConstants.DEFAULT_CHARSET;
    private static final HttpDataFactory DATA_FACTORY = new DefaultHttpDataFactory(true);
    private final File tmpDir;
    private HttpRequest currentRequest;
    private HttpPostRequestDecoder currentDecoder;
    private String currentRequestPath;

    public HttpRequestHandler(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.currentDecoder != null) {
            this.currentDecoder.cleanFiles();
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        block12: {
            try {
                if (msg instanceof HttpRequest) {
                    this.currentRequest = (HttpRequest)msg;
                    this.currentRequestPath = null;
                    if (this.currentDecoder != null) {
                        this.currentDecoder.destroy();
                        this.currentDecoder = null;
                    }
                    if (this.currentRequest.getMethod() == HttpMethod.GET || this.currentRequest.getMethod() == HttpMethod.DELETE) {
                        ctx.fireChannelRead((Object)this.currentRequest);
                        break block12;
                    }
                    if (this.currentRequest.getMethod() == HttpMethod.POST) {
                        this.currentRequestPath = new QueryStringDecoder(this.currentRequest.getUri(), ENCODING).path();
                        this.currentDecoder = new HttpPostRequestDecoder(DATA_FACTORY, this.currentRequest, ENCODING);
                        break block12;
                    }
                    throw new IOException("Unsupported HTTP method: " + this.currentRequest.getMethod().name());
                }
                if (this.currentDecoder == null || !(msg instanceof HttpContent)) break block12;
                HttpContent chunk = (HttpContent)msg;
                this.currentDecoder.offer(chunk);
                try {
                    while (this.currentDecoder.hasNext()) {
                        DiskFileUpload file;
                        InterfaceHttpData data = this.currentDecoder.next();
                        if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload || this.tmpDir == null || !(file = (DiskFileUpload)data).isCompleted()) continue;
                        String name = file.getFilename();
                        File target = new File(this.tmpDir, UUID.randomUUID() + "_" + name);
                        if (!this.tmpDir.exists()) {
                            WebRuntimeMonitor.logExternalUploadDirDeletion(this.tmpDir);
                            WebRuntimeMonitor.checkAndCreateUploadDir(this.tmpDir);
                        }
                        file.renameTo(target);
                        QueryStringEncoder encoder = new QueryStringEncoder(this.currentRequestPath);
                        encoder.addParam("filepath", target.getAbsolutePath());
                        encoder.addParam("filename", name);
                        this.currentRequest.setUri(encoder.toString());
                    }
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException data) {
                    // empty catch block
                }
                if (chunk instanceof LastHttpContent) {
                    HttpRequest request = this.currentRequest;
                    this.currentRequest = null;
                    this.currentRequestPath = null;
                    this.currentDecoder.destroy();
                    this.currentDecoder = null;
                    ctx.fireChannelRead((Object)request);
                }
            }
            catch (Throwable t) {
                this.currentRequest = null;
                this.currentRequestPath = null;
                if (this.currentDecoder != null) {
                    this.currentDecoder.destroy();
                    this.currentDecoder = null;
                }
                if (!ctx.channel().isActive()) break block12;
                byte[] bytes = ExceptionUtils.stringifyException((Throwable)t).getBytes(ENCODING);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.wrappedBuffer((byte[])bytes));
                response.headers().set("Content-Type", (Object)"text/plain");
                response.headers().set("Content-Length", (Object)response.content().readableBytes());
                ctx.writeAndFlush((Object)response);
            }
        }
    }
}

